/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.vanilla.overworld;

import divinerpg.entities.base.EntityDivineMonster;
import divinerpg.registries.SoundRegistry;
import divinerpg.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class EntityTheEye
extends EntityDivineMonster {
    public static final ResourceLocation ADVANCEMENT = ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"adventure/eye_of_evil");

    public EntityTheEye(EntityType<? extends EntityTheEye> type, Level level) {
        super(type, level);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.THE_EYE.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SoundRegistry.THE_EYE_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.THE_EYE_HURT.get();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
    }

    public boolean isSteppingCarefully() {
        return true;
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 64.0f));
    }

    public void tick() {
        super.tick();
        LivingEntity entity = this.getTarget();
        if (entity instanceof ServerPlayer) {
            ServerPlayer s = (ServerPlayer)entity;
            if (this.isLookingAt((LivingEntity)this, entity) || this.isLookingAt(entity, (LivingEntity)this)) {
                entity.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 120, 0, false, true));
                Utils.awardAdvancement(((ServerLevel)this.level()).getServer(), s, ADVANCEMENT, "look_into_the_eye");
            }
        }
    }

    boolean isLookingAt(LivingEntity target, LivingEntity looking) {
        Vec3 vec3 = looking.getViewVector(64.0f).normalize();
        Vec3 vec31 = new Vec3(target.getX() - looking.getX(), target.getEyeY() - looking.getEyeY(), target.getZ() - looking.getZ());
        double d0 = vec31.length();
        double d1 = vec3.dot(vec31 = vec31.normalize());
        return d1 > 1.0 - 0.025 / d0 && looking.hasLineOfSight((Entity)target);
    }
}

