/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.vanilla.overworld;

import divinerpg.entities.IAttackTimer;
import divinerpg.entities.base.EntityDivineTameable;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class EntityStoneGolem
extends EntityDivineTameable
implements IAttackTimer {
    public int attackTimer = 0;

    public EntityStoneGolem(EntityType<? extends TamableAnimal> type, Level worldIn) {
        super(type, worldIn, 1.0f);
    }

    public void tick() {
        super.tick();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
    }

    @Override
    public int getAttackTimer() {
        return this.attackTimer;
    }

    @Override
    public boolean isFood(ItemStack item) {
        return item.is(ItemTags.STONE_CRAFTING_MATERIALS);
    }

    @Override
    protected boolean isTamingFood(ItemStack item) {
        return item.is(ItemTags.STONE_CRAFTING_MATERIALS);
    }

    public boolean doHurtTarget(Entity entity) {
        boolean attack = super.doHurtTarget(entity);
        if (attack) {
            entity.setDeltaMovement((double)(-Mth.sin((float)(this.getXRot() * (float)Math.PI / 180.0f))), 0.1, (double)Mth.cos((float)(this.getXRot() * (float)Math.PI / 180.0f)));
            this.attackTimer = 10;
        }
        return attack;
    }
}

