/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.vanilla.overworld;

import divinerpg.entities.base.EntityDivineFlyingMonster;
import divinerpg.registries.AttachmentRegistry;
import divinerpg.registries.ParticleRegistry;
import divinerpg.registries.SoundRegistry;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class EntityRainbour
extends EntityDivineFlyingMonster
implements NeutralMob {
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.rangeOfSeconds((int)20, (int)39);
    private UUID angry_at;

    public EntityRainbour(EntityType<? extends EntityRainbour> type, Level worldIn) {
        super((EntityType<? extends EntityDivineFlyingMonster>)type, worldIn);
        this.xpReward = 10;
    }

    @Override
    protected void registerGoals() {
        this.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((EntityRainbour)this).isAngryAt(arg_0)));
        this.targetSelector.addGoal(2, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
        super.registerGoals();
    }

    public boolean isPreventingPlayerRest(Player player) {
        return this.isAngryAt((LivingEntity)player);
    }

    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide) {
            this.updatePersistentAnger((ServerLevel)this.level(), true);
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        UUID angry_at = this.getPersistentAngerTarget();
        if (angry_at != null) {
            compound.putUUID("angryAt", angry_at);
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("angryAt")) {
            this.angry_at = compound.getUUID("angryAt");
        }
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(PERSISTENT_ANGER_TIME.sample(this.random));
    }

    public void setRemainingPersistentAngerTime(int time) {
        AttachmentRegistry.ANGER_TIME.set((Entity)this, time);
    }

    public int getRemainingPersistentAngerTime() {
        return AttachmentRegistry.ANGER_TIME.get((Entity)this);
    }

    public void setPersistentAngerTarget(@Nullable UUID target) {
        this.angry_at = target;
        AttachmentRegistry.ANGRY.set((Entity)this, target != null);
    }

    @Nullable
    public UUID getPersistentAngerTarget() {
        if (((Boolean)AttachmentRegistry.ANGRY.get((Entity)this)).booleanValue()) {
            return this.angry_at;
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tick() {
        super.tick();
        for (int var3 = 0; var3 < 8; ++var3) {
            double d15 = this.getX() + this.random.nextDouble() * 0.6 + 0.2;
            double d20 = this.getY() + this.random.nextDouble() * 0.6 + 0.2;
            double d26 = this.getZ() + this.random.nextDouble() * 0.6 + 0.2;
            this.level().addParticle((ParticleOptions)ParticleRegistry.SPARKLER.get(), d15 * (double)this.getBbWidth() - 0.5, d20 + this.random.nextDouble() * (double)this.getBbHeight() - 0.25, d26 * (double)this.getBbWidth() - 0.5, (this.random.nextDouble() - 0.5) * 2.0, -this.random.nextDouble(), (this.random.nextDouble() - 0.5) * 2.0);
        }
    }

    public boolean isIgnoringBlockTriggers() {
        return true;
    }

    public boolean isMaxGroupSizeReached(int i) {
        return i > 1;
    }

    public int getMaxSpawnClusterSize() {
        return 1;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.RAINBOUR.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SoundRegistry.RAINBOUR_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.RAINBOUR_HURT.get();
    }
}

