/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.vanilla.overworld;

import divinerpg.entities.base.EntityDivineMonster;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.SoundRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.common.Tags;

public class EntityCaveclops
extends EntityDivineMonster
implements RangedAttackMob {
    public EntityCaveclops(EntityType<? extends EntityCaveclops> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FleeSunGoal((PathfinderMob)this, 0.27));
        this.goalSelector.addGoal(1, (Goal)new RangedAttackGoal((RangedAttackMob)this, 0.27, 30, 10.0f));
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.CYCLOPS.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SoundRegistry.CYCLOPS_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.CYCLOPS_HURT.get();
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        if (this.isAlive() && this.getTarget() != null && !this.level().isClientSide) {
            ThrowableProjectile projectile = (ThrowableProjectile)((EntityType)EntityRegistry.CAVE_ROCK.get()).create(this.level());
            projectile.setOwner((Entity)this);
            projectile.setPos(this.getEyePosition());
            double d0 = this.getTarget().getX() - this.getX();
            double d1 = this.getTarget().getY(0.3333333333333333) - projectile.getY();
            double d2 = this.getTarget().getZ() - this.getZ();
            double d3 = Mth.sqrt((float)((float)(d0 * d0 + d2 * d2)));
            projectile.shoot(d0, d1 + d3 * 0.2, d2, 1.6f, 0.8f);
            this.level().addFreshEntity((Entity)projectile);
        }
    }

    public static boolean caveClopsSpawnRule(ServerLevelAccessor worldIn, BlockPos pos) {
        return pos.getY() < 32 || worldIn.getBiome(pos).is(Tags.Biomes.IS_LUSH) && pos.getY() < 60;
    }
}

