/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.projectile.throwable;

import divinerpg.entities.projectile.DivineThrownItem;
import divinerpg.entities.projectile.throwable.EntityDisk;
import divinerpg.items.ranged.ItemThrowable;
import divinerpg.items.vethea.ItemVetheanDissipator;
import divinerpg.registries.ItemRegistry;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.HitResult;

public class Dissipator
extends EntityDisk {
    public Dissipator(EntityType<? extends DivineThrownItem> type, Level world) {
        super(type, world);
    }

    protected void onHit(HitResult result) {
        float f;
        Object object;
        super.onHit(result);
        Level level = this.level();
        ItemStack item = this.getItem();
        if (item.isEmpty() || !((object = item.getItem()) instanceof ItemThrowable)) {
            f = 3.0f;
        } else {
            ItemThrowable t = (ItemThrowable)((Object)object);
            f = t.damage;
        }
        float damage = f;
        ArrayList<BlockPos> list = ItemVetheanDissipator.getLocalDungeonAir(this.level(), this.blockPosition(), damage);
        if (!list.isEmpty()) {
            for (BlockPos pos : list) {
                level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 0.0, 0.1, 0.0);
                if (this.getRandom().nextInt(3) != 0) continue;
                this.playSound(SoundEvents.CANDLE_EXTINGUISH);
            }
            if (level instanceof ServerLevel) {
                Player p;
                ServerLevel l = (ServerLevel)level;
                Entity entity = this.getOwner();
                if (entity instanceof Player && !(p = (Player)entity).isCreative()) {
                    item.hurtAndBreak(1, l, (LivingEntity)p, i -> {});
                }
            }
            this.drop();
        }
    }

    @Override
    protected Item getDefaultItem() {
        return (Item)ItemRegistry.teaker_dissipator.get();
    }
}

