/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.projectile.magic;

import divinerpg.entities.projectile.magic.DivineArcanaProjectile;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class EntityBouncingProjectile
extends DivineArcanaProjectile {
    int bounces = 0;

    public EntityBouncingProjectile(EntityType<? extends ThrowableProjectile> type, Level world) {
        super(type, world);
    }

    @Override
    public void onHitBlock(BlockHitResult result) {
        this.hitBlockNoDiscard(result);
        Vec3 mv = this.getDeltaMovement();
        double x = mv.x;
        double y = mv.y;
        double z = mv.z;
        if (result.getDirection() == Direction.DOWN || result.getDirection() == Direction.UP) {
            this.lerpMotion(x * 0.8, y * -0.8, z * 0.8);
        } else if (result.getDirection() == Direction.EAST || result.getDirection() == Direction.WEST) {
            this.lerpMotion(x * -0.8, y * 0.8, z * 0.8);
        } else if (result.getDirection() == Direction.NORTH || result.getDirection() == Direction.SOUTH) {
            this.lerpMotion(x * 0.8, y * 0.8, z * -0.8);
        }
        if (this.bounces > 6) {
            this.discard();
        }
        ++this.bounces;
    }
}

