/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.projectile.fireball;

import divinerpg.entities.projectile.DivineFireball;
import divinerpg.registries.EntityRegistry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;

public class EntityScorcherShot
extends DivineFireball {
    public EntityScorcherShot(EntityType<? extends DivineFireball> type, Level world) {
        super(type, world);
    }

    public EntityScorcherShot(Level world, LivingEntity shooter, double accelX, double accelY, double accelZ) {
        super((EntityType<? extends DivineFireball>)((EntityType)EntityRegistry.SCORCHER_SHOT.get()), world, shooter, accelX, accelY, accelZ);
        this.moveTo(shooter.xo, shooter.yo, shooter.zo, shooter.getXRot(), shooter.getYRot());
        this.setPos(shooter.xo, shooter.yo, shooter.zo);
        double d = Math.sqrt(accelX * accelX + accelY * accelY + accelZ * accelZ);
        this.setDeltaMovement(accelX / d * 0.1, accelY / d * 0.1, accelZ / d * 0.1);
        this.setOwner((Entity)shooter);
    }

    public boolean hurt(DamageSource source, float amount) {
        return false;
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    @Override
    protected void onHitEntity(EntityHitResult result) {
        Level level;
        super.onHitEntity(result);
        if (this.tickCount > 1 && (level = this.level()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            Entity entity = result.getEntity();
            if (!entity.fireImmune()) {
                Entity entity1 = this.getOwner();
                int i = entity.getRemainingFireTicks();
                entity.igniteForSeconds(5.0f);
                DamageSource source = this.damageSources().fireball((Fireball)this, entity1);
                boolean flag = entity.hurt(source, 5.0f);
                if (!flag) {
                    entity.setRemainingFireTicks(i);
                } else if (entity1 instanceof LivingEntity) {
                    EnchantmentHelper.doPostAttackEffects((ServerLevel)level2, (Entity)entity1, (DamageSource)source);
                }
            }
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide()) {
            this.xo += (this.random.nextDouble() - this.random.nextDouble()) / 3.0;
            this.yo += (this.random.nextDouble() - this.random.nextDouble()) / 3.0;
            this.zo += (this.random.nextDouble() - this.random.nextDouble()) / 3.0;
        }
        if (this.level().isClientSide()) {
            for (int i = 0; i < 3; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.PORTAL, this.getX() + (this.random.nextDouble() - this.random.nextDouble()) / 5.0, this.getY() + 0.5 + (this.random.nextDouble() - this.random.nextDouble()) / 5.0, this.getZ() + (this.random.nextDouble() - this.random.nextDouble()) / 5.0, 0.0, 0.0, 0.0);
            }
        }
    }
}

