/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.projectile.fireball;

import divinerpg.entities.projectile.DivineFireball;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.MobEffectRegistry;
import divinerpg.registries.ParticleRegistry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;

public class EntityFrostShot
extends DivineFireball {
    public EntityFrostShot(EntityType<? extends DivineFireball> type, Level world) {
        super(type, world);
    }

    public EntityFrostShot(Level world, LivingEntity shooter, double accelX, double accelY, double accelZ) {
        super((EntityType<? extends DivineFireball>)((EntityType)EntityRegistry.FROST_SHOT.get()), world, shooter, accelX, accelY, accelZ);
    }

    public boolean hurt(DamageSource source, float amount) {
        return false;
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public boolean isOnFire() {
        return false;
    }

    @Override
    protected void onHit(HitResult result) {
        super.onHit(result);
        if (result.getType() != HitResult.Type.MISS) {
            if (!this.level().isClientSide()) {
                this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), 1.3f, false, Level.ExplosionInteraction.NONE);
                for (Entity entity : this.level().getEntities(this.getOwner(), new AABB(this.position().add(-3.0, -3.0, -3.0), this.position().add(3.0, 3.0, 3.0)))) {
                    LivingEntity l;
                    if (!(entity instanceof LivingEntity) || !(l = (LivingEntity)entity).canFreeze() || l.hasEffect(MobEffectRegistry.WARMTH)) continue;
                    l.setTicksFrozen(l.getTicksRequiredToFreeze() + 50);
                }
            }
            this.discard();
        }
    }

    @Override
    public void tick() {
        if (this.tickCount > 400) {
            this.discard();
        }
        super.tick();
        this.level().addParticle((ParticleOptions)ParticleRegistry.FROST.get(), this.xo + (double)(this.random.nextFloat() * 2.0f), this.yo + (double)(this.random.nextFloat() * 2.0f), this.zo + (double)(this.random.nextFloat() * 2.0f), 0.0, 1.0, 0.0);
    }
}

