/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.projectile.fireball;

import divinerpg.entities.projectile.DivineFireball;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.ParticleRegistry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class EntityFractiteShot
extends DivineFireball {
    public EntityFractiteShot(EntityType<? extends DivineFireball> type, Level world) {
        super(type, world);
        this.explosionPower = 1;
    }

    public EntityFractiteShot(Level world, LivingEntity shooter, double accelX, double accelY, double accelZ) {
        super((EntityType<? extends DivineFireball>)((EntityType)EntityRegistry.FRACTITE_SHOT.get()), world, shooter, accelX, accelY, accelZ, (byte)1);
    }

    public boolean fireImmune() {
        return true;
    }

    public boolean hurt(DamageSource source, float amount) {
        return false;
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public boolean isOnFire() {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void tick() {
        super.tick();
        for (int i = 0; i < 5; ++i) {
            this.level().addParticle((ParticleOptions)ParticleRegistry.FROST.get(), this.xo, this.yo, this.zo, 0.0, 1.0, 0.0);
            if (this.tickCount <= 40) continue;
            this.kill();
        }
    }
}

