/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.projectile;

import divinerpg.registries.AttachmentRegistry;
import divinerpg.registries.ItemRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public class Hook
extends Projectile
implements Leashable {
    Leashable.LeashData leashData;
    BlockState lastState;
    boolean inGround;
    public float hookDistance = 0.0f;

    public Hook(EntityType<? extends Projectile> entityType, Level level) {
        super(entityType, level);
    }

    @Nullable
    public Leashable.LeashData getLeashData() {
        return this.leashData;
    }

    public void setLeashData(Leashable.LeashData leashData) {
        this.leashData = leashData;
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        double d0 = this.getBoundingBox().getSize() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 *= 64.0 * Hook.getViewScale()) * d0;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        VoxelShape voxelshape;
        super.tick();
        Entity owner = this.getOwner();
        if (owner == null || !owner.isAlive()) {
            this.discard();
            return;
        }
        Vec3 dv = owner.position().subtract(this.position());
        if (dv.lengthSqr() > 4096.0) {
            dv = dv.normalize();
            this.setDeltaMovement(dv);
            this.hasImpulse = true;
        } else {
            dv = this.getDeltaMovement();
        }
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            double h = dv.horizontalDistance();
            this.setYRot((float)(Mth.atan2((double)dv.x, (double)dv.z) * 180.0 / Math.PI));
            this.setXRot((float)(Mth.atan2((double)dv.y, (double)h) * 180.0 / Math.PI));
            this.yRotO = this.getYRot();
            this.xRotO = this.getXRot();
        }
        BlockPos blockpos = this.blockPosition();
        BlockState blockstate = this.level().getBlockState(blockpos);
        if (!blockstate.isAir() && !(voxelshape = blockstate.getCollisionShape((BlockGetter)this.level(), blockpos)).isEmpty()) {
            for (AABB aabb : voxelshape.toAabbs()) {
                if (!aabb.move(blockpos).contains(this.position())) continue;
                this.hook(true);
                break;
            }
        }
        if (this.isInWaterOrRain() || blockstate.is(Blocks.POWDER_SNOW) || this.isInFluidType((fluidType, height) -> this.canFluidExtinguish((FluidType)fluidType))) {
            this.clearFire();
        }
        if (this.inGround) {
            if (this.lastState != blockstate && this.shouldFall()) {
                this.startFalling();
            }
        } else {
            Vec3 pos = this.position();
            Vec3 newpos = pos.add(dv);
            BlockHitResult hitresult = this.level().clip(new ClipContext(pos, newpos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            if (hitresult.getType() != HitResult.Type.MISS) {
                newpos = hitresult.getLocation();
            }
            if (!this.isRemoved() && hitresult != null && hitresult.getType() != HitResult.Type.MISS && !EventHooks.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
                this.hitTargetOrDeflectSelf((HitResult)hitresult);
                this.hasImpulse = true;
            }
            dv = this.getDeltaMovement();
            double dx = dv.x;
            double dy = dv.y;
            double dz = dv.z;
            double newx = this.getX() + dx;
            double newy = this.getY() + dy;
            double newz = this.getZ() + dz;
            double h = dv.horizontalDistance();
            this.setYRot((float)(Mth.atan2((double)dx, (double)dz) * 180.0 / Math.PI));
            this.setXRot((float)(Mth.atan2((double)newy, (double)h) * 180.0 / Math.PI));
            this.setXRot(Hook.lerpRotation((float)this.xRotO, (float)this.getXRot()));
            this.setYRot(Hook.lerpRotation((float)this.yRotO, (float)this.getYRot()));
            float f = 0.99f;
            if (this.isInWater()) {
                for (int j = 0; j < 4; ++j) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, newx - dx * 0.25, newy - dy * 0.25, newz - dz * 0.25, dx, dy, dz);
                }
                f = 0.6f;
            }
            this.setDeltaMovement(dv.scale((double)f));
            this.applyGravity();
            this.setPos(newx, newy, newz);
            this.checkInsideBlocks();
        }
        if (owner instanceof Player) {
            Player p = (Player)owner;
            boolean shift = p.isShiftKeyDown();
            if (shift && this.hookDistance > 0.0f && !p.onGround()) {
                this.hookDistance += 0.2f;
                if (this.hookDistance > 64.0f) {
                    this.hookDistance = 64.0f;
                }
            }
            if (p.isUsingItem() && p.getUseItem().is(ItemRegistry.jungle_hook)) {
                if (shift) {
                    this.discard();
                } else if (this.hookDistance > 0.0f) {
                    this.hookDistance -= 1.0f;
                    if (this.hookDistance < 0.2f) {
                        this.hookDistance = 0.2f;
                    }
                }
            }
        }
        if ((this.tickCount & 1) == 0) {
            Leashable.tickLeash((Entity)this);
        }
    }

    public void hook(boolean inGround) {
        if (inGround == this.inGround) {
            return;
        }
        if (inGround) {
            Entity owner = this.getOwner();
            if (owner == null) {
                this.discard();
            } else {
                this.inGround = true;
                this.hookDistance = this.distanceTo(owner) + 1.0f;
            }
        } else {
            this.inGround = false;
            this.hookDistance = 0.0f;
        }
    }

    public boolean handleLeashAtDistance(Entity leashHolder, float distance) {
        if (this.hookDistance > 0.0f && distance > this.hookDistance) {
            Vec3 diff = this.position().subtract(leashHolder.position());
            if ((diff = diff.scale((double)(distance - this.hookDistance) * 0.06 / (double)this.hookDistance).add(diff.scale(-0.1 * diff.dot(leashHolder.getDeltaMovement()) / (double)distance)).multiply(0.2, 1.0, 0.2)).length() > 0.01) {
                leashHolder.addDeltaMovement(diff);
                if (leashHolder.getDeltaMovement().y > -0.1) {
                    leashHolder.resetFallDistance();
                }
                leashHolder.hasImpulse = true;
            }
        }
        return false;
    }

    protected double getDefaultGravity() {
        return 0.0525;
    }

    private boolean shouldFall() {
        return this.inGround && this.level().noCollision((Entity)this, new AABB(this.position().subtract(0.1, 0.1, 0.1), this.position().add(0.1, 0.1, 0.1)));
    }

    private void startFalling() {
        this.hook(false);
        Vec3 vec3 = this.getDeltaMovement();
        this.setDeltaMovement(vec3.multiply((double)(this.random.nextFloat() * 0.2f), (double)(this.random.nextFloat() * 0.2f), (double)(this.random.nextFloat() * 0.2f)));
    }

    public void move(MoverType type, Vec3 pos) {
        super.move(type, pos);
        if (type != MoverType.SELF && this.shouldFall()) {
            this.startFalling();
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        this.lastState = this.level().getBlockState(result.getBlockPos());
        super.onHitBlock(result);
        Vec3 dv = result.getLocation().subtract(this.getX(), this.getY(), this.getZ());
        this.setDeltaMovement(dv);
        Vec3 smalldv = dv.normalize().scale(0.05);
        this.setPosRaw(this.getX() - smalldv.x, this.getY() - smalldv.y, this.getZ() - smalldv.z);
        this.hook(true);
    }

    public boolean shouldBeSaved() {
        return false;
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    public boolean isAttackable() {
        return false;
    }

    public void setOwner(@Nullable Entity owner) {
        ServerPlayer p;
        Entity entity = this.getOwner();
        if (entity instanceof ServerPlayer && owner != (p = (ServerPlayer)entity)) {
            AttachmentRegistry.HOOKED.set((Entity)p, false);
        }
        super.setOwner(owner);
        this.setLeashedTo(owner, !this.level().isClientSide);
        if (owner instanceof ServerPlayer) {
            AttachmentRegistry.HOOKED.set(owner, true);
        }
    }

    public void onRemovedFromLevel() {
        super.onRemovedFromLevel();
        Entity entity = this.getOwner();
        if (entity instanceof ServerPlayer) {
            ServerPlayer p = (ServerPlayer)entity;
            AttachmentRegistry.HOOKED.set((Entity)p, false);
        }
    }
}

