/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.projectile;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class DivineThrowableProjectile
extends ThrowableProjectile {
    public float baseDamage = 1.0f;

    public DivineThrowableProjectile(EntityType<? extends ThrowableProjectile> entityType, Level level, float damage) {
        this(entityType, level);
        this.baseDamage = damage;
    }

    public DivineThrowableProjectile(EntityType<? extends ThrowableProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public ProjectileDeflection deflection(Projectile projectile) {
        return ProjectileDeflection.NONE;
    }

    public void tick() {
        super.tick();
        if (this.tickCount > 200) {
            this.discard();
        }
    }

    public DamageSource getDamageSource(EntityHitResult result) {
        LivingEntity l;
        Entity entity;
        return this.damageSources().mobProjectile((Entity)this, (entity = this.getOwner()) instanceof LivingEntity ? (l = (LivingEntity)entity) : null);
    }

    protected void doPostHurtEffects(LivingEntity living) {
    }

    protected void onHitEntity(EntityHitResult result) {
        Level level;
        Entity entity = result.getEntity();
        float f = (float)this.getDeltaMovement().length();
        float d0 = this.baseDamage;
        Entity entity1 = this.getOwner();
        DamageSource damagesource = this.getDamageSource(result);
        if (this.getWeaponItem() != null && (level = this.level()) instanceof ServerLevel) {
            ServerLevel s = (ServerLevel)level;
            d0 = EnchantmentHelper.modifyDamage((ServerLevel)s, (ItemStack)this.getWeaponItem(), (Entity)entity, (DamageSource)damagesource, (float)this.baseDamage);
        }
        int j = Mth.ceil((double)Mth.clamp((double)(f * d0), (double)0.0, (double)2.147483647E9));
        int i = entity.getRemainingFireTicks();
        if (entity1 instanceof LivingEntity) {
            LivingEntity livingentity1 = (LivingEntity)entity1;
            livingentity1.setLastHurtMob(entity);
        }
        if (this.isOnFire()) {
            entity.igniteForSeconds(5.0f);
        }
        if (entity.hurt(damagesource, (float)j)) {
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                Level level2 = this.level();
                if (level2 instanceof ServerLevel) {
                    ServerLevel serverlevel1 = (ServerLevel)level2;
                    EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)serverlevel1, (Entity)livingentity, (DamageSource)damagesource, (ItemStack)this.getWeaponItem());
                }
                this.doPostHurtEffects(livingentity);
            }
            this.discard();
        } else {
            entity.setRemainingFireTicks(i);
            if (entity.invulnerableTime > 0 || entity.deflection((Projectile)this) == ProjectileDeflection.NONE) {
                this.discard();
            } else {
                this.deflect(ProjectileDeflection.REVERSE, entity, this.getOwner(), false);
                this.setDeltaMovement(this.getDeltaMovement().scale(0.2));
                if (!this.level().isClientSide && this.getDeltaMovement().lengthSqr() < 1.0E-7) {
                    this.discard();
                }
            }
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        this.discard();
    }

    protected void hitBlockNoDiscard(BlockHitResult result) {
        super.onHitBlock(result);
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putFloat("basDam", this.baseDamage);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.baseDamage = compound.getFloat("basDam");
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }
}

