/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.mortum;

import divinerpg.entities.base.EntityDivineMonster;
import divinerpg.registries.SoundRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;

public class EntitySoulStealer
extends EntityDivineMonster {
    private int attackAnimationTick;

    public EntitySoulStealer(EntityType<? extends EntitySoulStealer> type, Level worldIn) {
        super(type, worldIn);
    }

    public boolean fireImmune() {
        return true;
    }

    public void aiStep() {
        super.aiStep();
        if (this.attackAnimationTick > 0) {
            --this.attackAnimationTick;
        }
    }

    public boolean doHurtTarget(Entity target) {
        this.attackAnimationTick = 10;
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        boolean attack = super.doHurtTarget(target);
        if (attack) {
            ((LivingEntity)target).addEffect(new MobEffectInstance(MobEffects.CONFUSION, 240, 0, false, false));
            ((LivingEntity)target).addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 240, 0, false, false));
        }
        return attack;
    }

    public void handleEntityEvent(byte id) {
        if (id == 4) {
            this.attackAnimationTick = 10;
        }
        super.handleEntityEvent(id);
    }

    public int getAttackAnimationTick() {
        return this.attackAnimationTick;
    }

    public int getArmorValue() {
        return 10;
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader world) {
        return 0.0f;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.INSECT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SoundRegistry.INSECT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.INSECT.get();
    }
}

