/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.iceika.gruzzorlug;

import divinerpg.entities.iceika.gruzzorlug.Gruzzorlug;
import divinerpg.registries.AttachmentRegistry;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.ItemRegistry;
import divinerpg.registries.RecipeRegistry;
import divinerpg.registries.SoundRegistry;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;

public class GruzzorlugCommander
extends Gruzzorlug
implements RangedAttackMob {
    public GruzzorlugCommander(EntityType<? extends Gruzzorlug> type, Level worldIn) {
        super(type, worldIn);
        if (!worldIn.isClientSide()) {
            this.setData((Supplier)AttachmentRegistry.IMPORTANT.attachment, true);
        }
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        this.setItemInHand(InteractionHand.MAIN_HAND, ItemRegistry.fractite_cannon.toStack());
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new Gruzzorlug.AggressiveRangedAttackGoal(25));
    }

    public void performRangedAttack(LivingEntity target, float f) {
        if (this.isAlive() && this.getTarget() != null) {
            ThrowableProjectile projectile = (ThrowableProjectile)((EntityType)EntityRegistry.FRACTITE_CANNON_SHOT.get()).create(this.level());
            projectile.setOwner((Entity)this);
            projectile.setPos(this.getEyePosition());
            double d0 = this.getTarget().getX() - this.getX();
            double d1 = this.getTarget().getY(0.3333333333333333) - projectile.getY();
            double d2 = this.getTarget().getZ() - this.getZ();
            double d3 = Mth.sqrt((float)((float)(d0 * d0 + d2 * d2)));
            projectile.shoot(d0, d1 + d3 * 0.15, d2, 1.6f, 0.8f);
            this.level().addFreshEntity((Entity)projectile);
            this.playSound((SoundEvent)SoundRegistry.FRACTITE_CANNON.get());
        }
    }

    protected void updateTrades() {
        this.addOffersFromItemListings(this.getOffers(), RecipeRegistry.Trades.GRUZZORLUG_COMMANDER.get(this.level(), this.getRandom()), 3);
    }
}

