/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.iceika.groglin;

import divinerpg.entities.goals.FollowLeaderGoal;
import divinerpg.entities.iceika.groglin.Groglin;
import divinerpg.entities.iceika.groglin.GroglinSharlatan;
import divinerpg.entities.projectile.arrows.IcicleArrow;
import divinerpg.registries.ItemRegistry;
import divinerpg.registries.RecipeRegistry;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class GroglinHunter
extends Groglin
implements RangedAttackMob {
    public GroglinHunter(EntityType<? extends Groglin> type, Level worldIn) {
        super(type, worldIn);
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        this.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)ItemRegistry.icicle_bow.get()));
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new RangedBowAttackGoal((Mob)this, this.getAttribute(Attributes.MOVEMENT_SPEED).getBaseValue(), 20, (float)this.getAttribute(Attributes.FOLLOW_RANGE).getBaseValue()));
        this.goalSelector.addGoal(4, (Goal)new FollowLeaderGoal((Mob)this, GroglinSharlatan.class, 1.0, 4.0f, (float)this.getAttributeValue(Attributes.FOLLOW_RANGE)));
    }

    public void performRangedAttack(LivingEntity target, float f) {
        if (this.isAlive() && this.getTarget() != null && !this.level().isClientSide) {
            IcicleArrow abstractarrow = new IcicleArrow(this.level(), (LivingEntity)this, new ItemStack((ItemLike)ItemRegistry.icicle_arrow.get()), this.getItemBySlot(EquipmentSlot.MAINHAND));
            double d0 = target.getX() - this.getX();
            double d1 = target.getY(0.3333333333333333) - abstractarrow.getY();
            double d2 = target.getZ() - this.getZ();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            abstractarrow.shoot(d0, d1 + d3 * 0.2, d2, 1.6f, 14.0f - (float)(this.level().getDifficulty().getId() << 2));
            this.playSound(SoundEvents.SKELETON_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
            this.level().addFreshEntity((Entity)abstractarrow);
        }
    }

    protected void updateTrades() {
        this.addOffersFromItemListings(this.getOffers(), RecipeRegistry.Trades.GROGLIN_HUNTER.get(this.level(), this.getRandom()), 3);
    }
}

