/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.iceika;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import it.unimi.dsi.fastutil.floats.FloatArraySet;
import it.unimi.dsi.fastutil.floats.FloatArrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class EntitySnowSkipper
extends PathfinderMob {
    public EntitySnowSkipper(EntityType<? extends EntitySnowSkipper> type, Level worldIn) {
        super(type, worldIn);
        this.getNavigation().setCanFloat(true);
        this.setPathfindingMalus(PathType.DANGER_POWDER_SNOW, 0.0f);
        this.setPathfindingMalus(PathType.POWDER_SNOW, 0.0f);
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.RABBIT_HURT;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.RABBIT_DEATH;
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 6.0f, 1.0, 1.2));
        this.goalSelector.addGoal(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected PathNavigation createNavigation(Level level) {
        return new GroundPathNavigation(this, (Mob)this, level){

            protected PathFinder createPathFinder(int maxVisitedNodes) {
                this.nodeEvaluator = new WalkNodeEvaluator(){

                    public PathType getPathType(PathfindingContext context, int x, int y, int z) {
                        return EntitySnowSkipper.isTravelMedium(level.getBlockState(new BlockPos(x, y, z))) ? PathType.WALKABLE : super.getPathType(context, x, y, z);
                    }
                };
                return new PathFinder(this.nodeEvaluator, maxVisitedNodes);
            }

            protected boolean canUpdatePath() {
                return super.canUpdatePath() || EntitySnowSkipper.isTravelMedium(this.mob.getInBlockState());
            }
        };
    }

    public static boolean isTravelMedium(BlockState state) {
        return state.is(Blocks.POWDER_SNOW) || state.is(Blocks.SNOW_BLOCK) || state.is(Blocks.SNOW);
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return source.is(DamageTypes.IN_WALL) && !EntitySnowSkipper.isTravelMedium(this.getInBlockState()) || super.isInvulnerableTo(source);
    }

    public boolean isColliding(BlockPos pos, BlockState state) {
        return !EntitySnowSkipper.isTravelMedium(state) && super.isColliding(pos, state);
    }

    public boolean isInWall() {
        return !EntitySnowSkipper.isTravelMedium(this.getInBlockState()) && super.isInWall();
    }

    public void travel(Vec3 travelVector) {
        super.travel(travelVector);
        if (this.isPathFinding()) {
            if (EntitySnowSkipper.isTravelMedium(this.getInBlockState())) {
                this.addDeltaMovement(new Vec3(this.getDeltaMovement().x * 0.01, 0.15, this.getDeltaMovement().z * 0.01));
            } else if (EntitySnowSkipper.isTravelMedium(this.getBlockStateOn())) {
                this.jumpFromGround();
            }
        }
    }

    public void move(MoverType type, Vec3 dv) {
        AABB aabb = this.getBoundingBox().expandTowards(dv).deflate(1.0E-6);
        if (this.level().getBlockStatesIfLoaded(aabb).anyMatch(EntitySnowSkipper::isTravelMedium)) {
            dv = this.collide(dv, aabb);
            this.setPos(this.getX() + dv.x, this.getY() + dv.y, this.getZ() + dv.z);
        } else {
            super.move(type, dv);
        }
    }

    public Vec3 collide(Vec3 vec, AABB expandedBox) {
        boolean groundcollision;
        AABB aabb = this.getBoundingBox();
        List list = this.level().getEntityCollisions((Entity)this, expandedBox);
        Vec3 vec3 = vec.lengthSqr() == 0.0 ? vec : this.getBlockCollisions(vec, aabb, expandedBox, list);
        boolean xcollision = vec.x != vec3.x;
        boolean ycollision = vec.y != vec3.y;
        boolean zcollision = vec.z != vec3.z;
        boolean bl = groundcollision = ycollision && vec.y < 0.0;
        if (this.maxUpStep() > 0.0f && (groundcollision || this.onGround()) && (xcollision || zcollision)) {
            float[] afloat;
            AABB aabb1 = groundcollision ? aabb.move(0.0, vec3.y, 0.0) : aabb;
            AABB aabb2 = aabb1.expandTowards(vec.x, (double)this.maxUpStep(), vec.z);
            if (!groundcollision) {
                aabb2 = aabb2.expandTowards(0.0, -1.0E-5, 0.0);
            }
            List<VoxelShape> list1 = this.collectColliders(list, aabb2);
            for (float f1 : afloat = EntitySnowSkipper.collectCandidateStepUpHeights(aabb1, list1, this.maxUpStep(), (float)vec3.y)) {
                Vec3 vec31 = EntitySnowSkipper.collideWithShapes(new Vec3(vec.x, (double)f1, vec.z), aabb1, list1);
                if (!(vec31.horizontalDistanceSqr() > vec3.horizontalDistanceSqr())) continue;
                return vec31.add(0.0, aabb1.minY - aabb.minY, 0.0);
            }
        }
        return vec3;
    }

    public Vec3 getBlockCollisions(Vec3 vec, AABB collisionBox, AABB expandedBox, List<VoxelShape> potentialHits) {
        List<VoxelShape> list = this.collectColliders(potentialHits, expandedBox);
        return EntitySnowSkipper.collideWithShapes(vec, collisionBox, list);
    }

    public List<VoxelShape> collectColliders(List<VoxelShape> collisions, AABB boundingBox) {
        WorldBorder worldborder;
        boolean flag;
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(collisions.size() + 1));
        if (!collisions.isEmpty()) {
            builder.addAll(collisions);
        }
        if (flag = (worldborder = this.level().getWorldBorder()).isInsideCloseToBorder((Entity)this, boundingBox)) {
            builder.add((Object)worldborder.getCollisionShape());
        }
        CollisionContext context = CollisionContext.of((Entity)this);
        VoxelShape entityShape = Shapes.create((AABB)boundingBox);
        BlockGetter[] cachedBlockGetter = new BlockGetter[]{null};
        AtomicLong cachedBlockGetterPos = new AtomicLong(0L);
        BlockPos.betweenClosedStream((AABB)boundingBox).forEach(pos -> {
            double x = pos.getX();
            double y = pos.getY();
            double z = pos.getZ();
            int i = SectionPos.blockToSectionCoord((double)x);
            int j = SectionPos.blockToSectionCoord((double)z);
            long k = ChunkPos.asLong((int)i, (int)j);
            if (cachedBlockGetter[0] == null || cachedBlockGetterPos.get() != k) {
                BlockGetter blockgetter;
                cachedBlockGetter[0] = blockgetter = this.level().getChunkForCollisions(i, j);
                cachedBlockGetterPos.set(k);
            }
            if (cachedBlockGetter[0] == null) {
                return;
            }
            BlockState state = cachedBlockGetter[0].getBlockState(pos);
            if (!EntitySnowSkipper.isTravelMedium(state)) {
                VoxelShape voxelshape = state.getCollisionShape((BlockGetter)this.level(), pos, context);
                if (voxelshape == Shapes.block() && boundingBox.intersects(x, y, z, x + 1.0, y + 1.0, z + 1.0)) {
                    builder.add((Object)voxelshape.move(x, y, z));
                }
                if (!(voxelshape = voxelshape.move(x, y, z)).isEmpty() && Shapes.joinIsNotEmpty((VoxelShape)voxelshape, (VoxelShape)entityShape, (BooleanOp)BooleanOp.AND)) {
                    builder.add((Object)voxelshape);
                }
            }
        });
        return builder.build();
    }

    public static float[] collectCandidateStepUpHeights(AABB box, List<VoxelShape> colliders, float deltaY, float maxUpStep) {
        FloatArraySet floatset = new FloatArraySet(4);
        block0: for (VoxelShape voxelshape : colliders) {
            DoubleListIterator doubleListIterator = voxelshape.getCoords(Direction.Axis.Y).iterator();
            while (doubleListIterator.hasNext()) {
                double d0 = (Double)doubleListIterator.next();
                float f = (float)(d0 - box.minY);
                if (f < 0.0f || f == maxUpStep) continue;
                if (f > deltaY) continue block0;
                floatset.add(f);
            }
        }
        float[] afloat = floatset.toFloatArray();
        FloatArrays.unstableSort((float[])afloat);
        return afloat;
    }

    public static Vec3 collideWithShapes(Vec3 deltaMovement, AABB entityBB, List<VoxelShape> shapes) {
        boolean flag;
        if (shapes.isEmpty()) {
            return deltaMovement;
        }
        double d0 = deltaMovement.x;
        double d1 = deltaMovement.y;
        double d2 = deltaMovement.z;
        if (d1 != 0.0 && (d1 = Shapes.collide((Direction.Axis)Direction.Axis.Y, (AABB)entityBB, shapes, (double)d1)) != 0.0) {
            entityBB = entityBB.move(0.0, d1, 0.0);
        }
        boolean bl = flag = Math.abs(d0) < Math.abs(d2);
        if (flag && d2 != 0.0 && (d2 = Shapes.collide((Direction.Axis)Direction.Axis.Z, (AABB)entityBB, shapes, (double)d2)) != 0.0) {
            entityBB = entityBB.move(0.0, 0.0, d2);
        }
        if (d0 != 0.0) {
            d0 = Shapes.collide((Direction.Axis)Direction.Axis.X, (AABB)entityBB, shapes, (double)d0);
            if (!flag && d0 != 0.0) {
                entityBB = entityBB.move(d0, 0.0, 0.0);
            }
        }
        if (!flag && d2 != 0.0) {
            d2 = Shapes.collide((Direction.Axis)Direction.Axis.Z, (AABB)entityBB, shapes, (double)d2);
        }
        return new Vec3(d0, d1, d2);
    }
}

