/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.iceika;

import divinerpg.block_entities.block.RobbinHutBlockEntity;
import divinerpg.block_entities.block.RobbinNestBlockEntity;
import divinerpg.blocks.iceika.BlockRobbinHut;
import divinerpg.entities.base.EntityDivineFlyingMonster;
import divinerpg.entities.boss.EntityKitra;
import divinerpg.registries.BlockRegistry;
import divinerpg.registries.ItemRegistry;
import divinerpg.util.Utils;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityRobbin
extends EntityDivineFlyingMonster {
    private int tiredTicks = 0;
    public boolean wantsNest = false;

    public EntityRobbin(EntityType<? extends EntityRobbin> entityType, Level world) {
        super((EntityType<? extends EntityDivineFlyingMonster>)entityType, world);
        this.moveControl = new RobbinMoveControl(this);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("MouthPiece")) {
            this.setMouthPiece(ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)tag.getCompound("MouthPiece")).orElse(ItemStack.EMPTY));
        }
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new FollowWhaleGoal());
        this.goalSelector.addGoal(2, (Goal)new GoalRideWhaleWhenTired());
        this.goalSelector.addGoal(6, (Goal)new RobbinRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, EntityKitra.class, 6.0f));
    }

    protected boolean shouldDespawnInPeaceful() {
        return false;
    }

    public boolean isMaxGroupSizeReached(int i) {
        return i > 6;
    }

    public boolean isTired() {
        return this.tiredTicks > 1200;
    }

    public void setMouthPiece(ItemStack item) {
        if (item == null) {
            item = ItemStack.EMPTY;
        }
        this.setItemSlot(EquipmentSlot.MAINHAND, item);
    }

    public void die(DamageSource source) {
        super.die(source);
        ItemStack item = this.getItemBySlot(EquipmentSlot.MAINHAND);
        if (!item.isEmpty()) {
            this.level().addFreshEntity((Entity)new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), item));
        }
    }

    protected float getJumpPower() {
        return 0.22f * this.getBlockJumpFactor() + this.getJumpBoostPower();
    }

    @Override
    public void reachTarget() {
        BlockEntity block2;
        Path path = this.getNavigation().getPath();
        BlockPos targetPos = path.getTarget();
        BlockState target = this.level().getBlockState(targetPos);
        if (target.is((Block)BlockRegistry.robbinHut.get()) && BlockRobbinHut.hasSpace((ServerLevel)this.level(), targetPos)) {
            RobbinHutBlockEntity block2 = (RobbinHutBlockEntity)this.level().getBlockEntity(targetPos);
            CompoundTag tag = new CompoundTag();
            this.save(tag);
            if (block2.robbin1 == null) {
                block2.robbin1 = tag;
            } else {
                block2.robbin2 = tag;
            }
            this.remove(Entity.RemovalReason.DISCARDED);
        } else if (target.is((Block)BlockRegistry.robbinNest.get()) && (block2 = this.level().getBlockEntity(targetPos)) instanceof RobbinNestBlockEntity) {
            RobbinNestBlockEntity nest = (RobbinNestBlockEntity)block2;
            if (this.wantsNest && !nest.getItem().is((Item)ItemRegistry.robbin_egg.get())) {
                if (!nest.isEmpty()) {
                    this.level().addFreshEntity((Entity)new ItemEntity(this.level(), (double)targetPos.getX() + 0.5, (double)targetPos.getY() + 0.1, (double)targetPos.getZ() + 0.5, nest.getItem()));
                }
                nest.setItem(((Item)ItemRegistry.robbin_egg.get()).getDefaultInstance());
                this.level().playSound((Entity)this, targetPos, SoundEvents.BEEHIVE_ENTER, SoundSource.NEUTRAL, 0.5f, 1.5f);
            } else if (nest.isEmpty() && !this.getItemBySlot(EquipmentSlot.MAINHAND).isEmpty()) {
                nest.setItem(this.getItemBySlot(EquipmentSlot.MAINHAND));
                this.level().playSound((Entity)this, targetPos, SoundEvents.BEEHIVE_ENTER, SoundSource.NEUTRAL, 0.5f, 1.5f);
                this.setMouthPiece(ItemStack.EMPTY);
            }
        } else {
            List items = this.level().getEntitiesOfClass(ItemEntity.class, new AABB(-1.0, -1.0, -1.0, 1.0, 1.0, 1.0));
            if (!items.isEmpty()) {
                this.setMouthPiece(((ItemEntity)items.getFirst()).getItem());
                this.level().playSound((Entity)this, targetPos, SoundEvents.ITEM_PICKUP, SoundSource.NEUTRAL, 0.5f, 1.0f);
                ((ItemEntity)items.getFirst()).discard();
            }
        }
    }

    @Override
    protected void customServerAiStep() {
        Path path = this.getNavigation().getPath();
        if (path == null && this.tiredTicks % 10 == 0) {
            if (this.isTired()) {
                EntityKitra nearbyWhale = (EntityKitra)this.level().getNearestEntity(EntityKitra.class, TargetingConditions.DEFAULT, (LivingEntity)this, this.getX(), this.getY(), this.getZ(), this.getBoundingBox().inflate(32.0));
                if (nearbyWhale == null) {
                    BlockPos pos;
                    int z;
                    int y;
                    int x;
                    for (x = this.blockPosition().getX() - 5; x < this.blockPosition().getX() + 5; ++x) {
                        for (y = this.blockPosition().getY() - 5; y < this.blockPosition().getY() + 5; ++y) {
                            for (z = this.blockPosition().getZ() - 5; z < this.blockPosition().getZ() + 5; ++z) {
                                pos = new BlockPos(x, y, z);
                                if (this.level().isOutsideBuildHeight(pos) || !this.level().getBlockState(pos).is((Block)BlockRegistry.robbinHut.get())) continue;
                                this.getNavigation().moveTo((double)x, (double)y, (double)z, 1.0);
                                return;
                            }
                        }
                    }
                    for (x = this.blockPosition().getX() - 5; x < this.blockPosition().getX() + 5; ++x) {
                        for (y = this.blockPosition().getY() - 5; y < this.blockPosition().getY() + 5; ++y) {
                            for (z = this.blockPosition().getZ() - 5; z < this.blockPosition().getZ() + 5; ++z) {
                                pos = new BlockPos(x, y, z);
                                if (this.level().isOutsideBuildHeight(pos) || !this.level().getBlockState(pos).isFaceSturdy((BlockGetter)this.level(), pos, Direction.UP)) continue;
                                BlockPos.MutableBlockPos mut = pos.mutable();
                                while (this.level().isOutsideBuildHeight((BlockPos)mut.move(Direction.UP)) || this.level().getBlockState((BlockPos)mut).isFaceSturdy((BlockGetter)this.level(), pos, Direction.UP) && ++y < this.blockPosition().getY() + 7) {
                                }
                                this.getNavigation().moveTo((double)x, (double)y, (double)z, 1.0);
                                return;
                            }
                        }
                    }
                } else {
                    this.pathfindPos = nearbyWhale.position();
                }
            } else if (this.wantsNest || !this.getItemBySlot(EquipmentSlot.MAINHAND).isEmpty()) {
                for (int x = this.blockPosition().getX() - 5; x < this.blockPosition().getX() + 5; ++x) {
                    for (int y = this.blockPosition().getY() - 5; y < this.blockPosition().getY() + 5; ++y) {
                        for (int z = this.blockPosition().getZ() - 5; z < this.blockPosition().getZ() + 5; ++z) {
                            RobbinNestBlockEntity nest;
                            BlockEntity blockEntity;
                            BlockPos pos = new BlockPos(x, y, z);
                            if (this.level().isOutsideBuildHeight(pos) || !this.level().getBlockState(pos).is((Block)BlockRegistry.robbinNest.get()) || !((blockEntity = this.level().getBlockEntity(pos)) instanceof RobbinNestBlockEntity) || !(nest = (RobbinNestBlockEntity)blockEntity).isEmpty() && (!this.wantsNest || nest.getItem().is((Item)ItemRegistry.robbin_egg.get()))) continue;
                            this.getNavigation().moveTo((double)x, (double)y, (double)z, 1.0);
                        }
                    }
                }
            } else {
                List items = this.level().getEntities((Entity)this, new AABB(-5.0, -5.0, -5.0, 5.0, 5.0, 5.0), entity -> entity instanceof ItemEntity);
                if (!items.isEmpty()) {
                    ItemEntity nearest = (ItemEntity)items.getFirst();
                    for (Entity e : items) {
                        if (!(this.distanceTo(e) < this.distanceTo((Entity)nearest))) continue;
                        nearest = (ItemEntity)e;
                    }
                    this.getNavigation().moveTo((Entity)nearest, 1.0);
                }
            }
        }
        if (this.isNoGravity()) {
            ++this.tiredTicks;
            super.customServerAiStep();
            if (this.onGround()) {
                this.setNoGravity(false);
            }
        } else if (this.tiredTicks > 0) {
            --this.tiredTicks;
        } else if (this.random.nextBoolean()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.2, 0.0));
            this.setNoGravity(true);
        }
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    static class RobbinMoveControl
    extends MoveControl {
        private int jumpDelay;

        RobbinMoveControl(EntityRobbin entity) {
            super((Mob)entity);
        }

        void setWantedMovement(double speedModifier) {
            this.speedModifier = speedModifier;
            this.operation = MoveControl.Operation.MOVE_TO;
        }

        public void tick() {
            this.mob.yHeadRot = this.mob.getYRot();
            this.mob.yBodyRot = this.mob.getYRot();
            if (this.operation != MoveControl.Operation.MOVE_TO) {
                this.mob.setZza(0.0f);
            } else {
                this.operation = MoveControl.Operation.WAIT;
                if (this.mob.onGround()) {
                    this.mob.setSpeed((float)(this.speedModifier * this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED)));
                    if (this.jumpDelay-- <= 0) {
                        this.jumpDelay = this.mob.getRandom().nextInt(10) + 1;
                        this.mob.getJumpControl().jump();
                    } else {
                        this.mob.xxa = 0.0f;
                        this.mob.zza = 0.0f;
                        this.mob.setSpeed(0.0f);
                    }
                } else {
                    this.mob.setSpeed((float)(this.speedModifier * this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED)));
                }
            }
        }
    }

    class FollowWhaleGoal
    extends Goal {
        private static final double FOLLOW_DISTANCE = 32.0;
        private static final double CIRCLE_RADIUS = 5.0;
        private EntityKitra targetWhale;

        FollowWhaleGoal() {
        }

        public boolean canUse() {
            if (this.targetWhale == null || !this.targetWhale.isAlive()) {
                this.targetWhale = (EntityKitra)EntityRobbin.this.level().getNearestEntity(EntityKitra.class, TargetingConditions.DEFAULT, (LivingEntity)EntityRobbin.this, EntityRobbin.this.getX(), EntityRobbin.this.getY(), EntityRobbin.this.getZ(), EntityRobbin.this.getBoundingBox().inflate(32.0));
            }
            return this.targetWhale != null;
        }

        public void start() {
            EntityRobbin.this.getNavigation().stop();
        }

        public void tick() {
            double distanceToWhale = EntityRobbin.this.distanceTo((Entity)this.targetWhale);
            if (distanceToWhale <= 32.0) {
                double angleToWhale = Math.atan2(this.targetWhale.getZ() - EntityRobbin.this.getZ(), this.targetWhale.getX() - EntityRobbin.this.getX());
                EntityRobbin.this.pathfindPos = new Vec3(this.targetWhale.getX() + 5.0 * Math.cos(angleToWhale), this.targetWhale.getY() + 5.0, this.targetWhale.getZ() + 5.0 * Math.sin(angleToWhale));
            } else {
                EntityRobbin.this.pathfindPos = this.targetWhale.position();
            }
        }

        public void stop() {
            EntityRobbin.this.getNavigation().stop();
        }
    }

    public class GoalRideWhaleWhenTired
    extends Goal {
        private EntityKitra whale;
        private int rideTime;

        public GoalRideWhaleWhenTired() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            if (EntityRobbin.this.isTired()) {
                this.whale = (EntityKitra)EntityRobbin.this.level().getNearestEntity(EntityKitra.class, TargetingConditions.DEFAULT, (LivingEntity)EntityRobbin.this, EntityRobbin.this.getX(), EntityRobbin.this.getY(), EntityRobbin.this.getZ(), EntityRobbin.this.getBoundingBox().inflate(16.0));
                return this.whale != null && EntityRobbin.this.distanceTo((Entity)this.whale) < 3.0f && this.whale.getPassengers().isEmpty();
            }
            return false;
        }

        public void start() {
            EntityRobbin.this.startRiding((Entity)this.whale);
            this.rideTime = 0;
        }

        public void stop() {
            EntityRobbin.this.stopRiding();
            this.whale = null;
            this.rideTime = 0;
        }

        public boolean canContinueToUse() {
            return EntityRobbin.this.isTired() && this.whale != null && !this.whale.isInWater() && this.rideTime < 200;
        }

        public void tick() {
            ++this.rideTime;
            if (EntityRobbin.this.isInWater()) {
                this.stop();
            }
        }
    }

    class RobbinRandomStrollGoal
    extends WaterAvoidingRandomStrollGoal {
        public RobbinRandomStrollGoal(PathfinderMob mob, double speedModifier) {
            super(mob, speedModifier);
        }

        public boolean canUse() {
            return !EntityRobbin.this.isNoGravity() && EntityRobbin.this.getNavigation().getPath() == null && super.canUse();
        }

        public boolean canContinueToUse() {
            return !EntityRobbin.this.isNoGravity() && super.canContinueToUse();
        }

        public void tick() {
            super.tick();
            Path path = EntityRobbin.this.getNavigation().getPath();
            if (path != null) {
                double distanceX = (double)path.getNextNodePos().getX() - EntityRobbin.this.getX();
                double distanceZ = (double)path.getNextNodePos().getZ() - EntityRobbin.this.getZ();
                EntityRobbin.this.yHeadRot = Utils.rotlerp(EntityRobbin.this.getYRot(), (float)(Mth.atan2((double)distanceZ, (double)distanceX) * 180.0 / Math.PI) - 90.0f, 90.0f);
            }
        }
    }
}

