/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.iceika;

import divinerpg.entities.base.EntityDivineMerchant;
import divinerpg.entities.base.FactionEntity;
import divinerpg.entities.goals.FactionTargetGoal;
import divinerpg.registries.AttachmentRegistry;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.PathType;

public abstract class EntityIceikaNPC
extends EntityDivineMerchant
implements FactionEntity {
    public EntityIceikaNPC(EntityType<? extends EntityDivineMerchant> type, Level worldIn, String profession) {
        super(type, worldIn, profession);
        this.setPathfindingMalus(PathType.POWDER_SNOW, -1.0f);
    }

    protected abstract Holder<MobEffect> getTargetEffect();

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        if (!(this instanceof RangedAttackMob)) {
            this.goalSelector.addGoal(0, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        }
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, new FactionTargetGoal((Mob)this, this.getFaction(), true, !(this instanceof RangedAttackMob)));
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    protected PathNavigation createNavigation(Level level) {
        GroundPathNavigation nav = new GroundPathNavigation((Mob)this, level);
        nav.setCanOpenDoors(true);
        nav.setCanPassDoors(true);
        return nav;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType type, @Nullable SpawnGroupData data) {
        RandomSource random = level.getRandom();
        this.populateDefaultEquipmentSlots(random, difficulty);
        this.populateDefaultEquipmentEnchantments(level, random, difficulty);
        return data;
    }

    @Override
    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (this.getFaction().likes((LivingEntity)player)) {
            return super.mobInteract(player, hand);
        }
        this.playSound(SoundEvents.VILLAGER_NO);
        return InteractionResult.FAIL;
    }

    public void die(DamageSource source) {
        if (this.level() instanceof ServerLevel) {
            this.modifyReputationOnDeath(source);
        }
        super.die(source);
    }

    @Override
    public void modifyReputationOnDeath(DamageSource source) {
        if (this.isImportant()) {
            LivingEntity entity;
            Entity entity2;
            if (source.getDirectEntity() != null && (entity2 = source.getDirectEntity()) instanceof LivingEntity) {
                entity = (LivingEntity)entity2;
                entity.addEffect(new MobEffectInstance(this.getTargetEffect(), -1, 0, false, false, true));
            }
            if (source.getEntity() != null && (entity2 = source.getEntity()) instanceof LivingEntity) {
                entity = (LivingEntity)entity2;
                entity.addEffect(new MobEffectInstance(this.getTargetEffect(), -1, 0, false, false, true));
            }
        }
        FactionEntity.super.modifyReputationOnDeath(source);
    }

    public boolean isImportant() {
        return AttachmentRegistry.IMPORTANT.get((Entity)this);
    }

    public boolean hurt(DamageSource source, float f) {
        if (this.level() instanceof ServerLevel) {
            this.modifyReputationOnHurt(source, f);
        }
        return super.hurt(source, f);
    }

    protected boolean shouldDespawnInPeaceful() {
        return false;
    }

    @Override
    public String[] getChatMessages() {
        return new String[0];
    }

    @Override
    protected void rewardTradeXp(MerchantOffer offer) {
        super.rewardTradeXp(offer);
        Player player = this.getTradingPlayer();
        if (player != null && offer.shouldRewardExp()) {
            this.getFaction().reputation.modify((Entity)player, 1);
        }
    }
}

