/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.iceika;

import divinerpg.entities.iceika.EntitySeng;
import divinerpg.enums.EntityStats;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

public class EntityDolossal
extends AbstractHorse {
    private static final Ingredient FOOD = Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"winterberry"))});

    public EntityDolossal(EntityType<? extends EntityDolossal> type, Level level) {
        super(type, level);
        this.getNavigation().setCanFloat(true);
        this.setPathfindingMalus(PathType.POWDER_SNOW, -1.0f);
        this.setPathfindingMalus(PathType.DANGER_POWDER_SNOW, -1.0f);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, EntitySeng.class, 7.0f, 1.0, 1.2));
    }

    public void aiStep() {
        block3: {
            block5: {
                block4: {
                    super.aiStep();
                    if (!(this.getDeltaMovement().y < 0.0)) break block3;
                    LivingEntity livingEntity = this.getControllingPassenger();
                    if (!(livingEntity instanceof LocalPlayer)) break block4;
                    LocalPlayer player = (LocalPlayer)livingEntity;
                    if (player.input.jumping) break block5;
                }
                if (this.hasControllingPassenger() || this.onGround()) break block3;
            }
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.05, 0.6, 1.05));
            this.fallDistance = 0.0f;
            for (Entity entity : this.getPassengers()) {
                entity.fallDistance = 0.0f;
            }
        }
    }

    protected void randomizeAttributes(RandomSource random) {
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue((double)EntityDolossal.generateMaxHealth(arg_0 -> ((RandomSource)random).nextInt(arg_0)));
        this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(EntityDolossal.generateSpeed(() -> ((RandomSource)random).nextDouble()));
        this.getAttribute(Attributes.JUMP_STRENGTH).setBaseValue(EntityDolossal.generateJumpStrength(() -> ((RandomSource)random).nextDouble()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canMate(Animal animal) {
        if (animal == this) return false;
        if (!(animal instanceof EntityDolossal)) return false;
        EntityDolossal dol = (EntityDolossal)animal;
        if (!this.canParent()) return false;
        if (!dol.canParent()) return false;
        return true;
    }

    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob mob) {
        EntityDolossal dol = (EntityDolossal)((EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"dolossal"))).create((Level)level);
        if (dol != null) {
            this.setOffspringAttributes(mob, dol);
        }
        return dol;
    }

    public boolean isFood(ItemStack stack) {
        return FOOD.test(stack);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (FOOD.test(stack)) {
            stack.consume(1, (LivingEntity)player);
            this.handleEating(player, stack);
            return InteractionResult.CONSUME;
        }
        return super.mobInteract(player, hand);
    }

    protected boolean handleEating(Player player, ItemStack item) {
        boolean flag = false;
        if (FOOD.test(item)) {
            if (!this.level().isClientSide() && this.isTamed() && this.getAge() == 0 && !this.isInLove()) {
                flag = true;
                this.setInLove(player);
            }
            if (this.getHealth() < this.getMaxHealth()) {
                this.heal(3.0f);
                flag = true;
            }
            if (this.isBaby()) {
                this.level().addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), 0.0, 0.0, 0.0);
                if (!this.level().isClientSide()) {
                    this.ageUp(60);
                }
                flag = true;
            }
            if ((flag || !this.isTamed()) && this.getTemper() < this.getMaxTemper()) {
                flag = true;
                if (!this.level().isClientSide()) {
                    this.modifyTemper(3);
                }
            }
            if (flag) {
                SoundEvent soundevent;
                if (!this.isSilent() && (soundevent = this.getEatingSound()) != null) {
                    this.level().playSound((Player)null, this.getX(), this.getY(), this.getZ(), soundevent, this.getSoundSource(), 1.0f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.2f);
                }
                this.gameEvent((Holder)GameEvent.EAT);
            }
        }
        return flag;
    }

    protected void playStepSound(BlockPos pos, BlockState stat) {
        this.playSound(SoundEvents.CHICKEN_STEP, 0.25f, 0.6f);
    }

    protected void playJumpSound() {
        this.playSound(SoundEvents.RABBIT_JUMP);
    }

    public static final <T extends Mob> void registerDolossalAttributes(EntityAttributeCreationEvent event, DeferredHolder<EntityType<?>, EntityType<T>> entity) {
        EntityStats stats = EntityStats.DOLOSSAL;
        event.put((EntityType)entity.get(), Mob.createMobAttributes().add(Attributes.MAX_HEALTH, stats.getHealth()).add(Attributes.ATTACK_DAMAGE, stats.getAttackDamage()).add(Attributes.MOVEMENT_SPEED, stats.getMovementSpeed()).add(Attributes.FOLLOW_RANGE, stats.getFollowRange()).add(Attributes.FLYING_SPEED, stats.getMovementSpeed()).add(Attributes.JUMP_STRENGTH, 1.0).build());
    }
}

