/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.iceika;

import divinerpg.registries.ItemRegistry;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AABB;

public class EntityCauldronFish
extends Squid
implements Bucketable {
    boolean fromBucket;

    public EntityCauldronFish(EntityType<EntityCauldronFish> type, Level level) {
        super(type, level);
        this.setPathfindingMalus(PathType.RAIL, 1.0f);
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.TROPICAL_FISH_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.TROPICAL_FISH_HURT;
    }

    protected SoundEvent getSquirtSound() {
        return SoundEvents.TROPICAL_FISH_HURT;
    }

    protected ParticleOptions getInkParticle() {
        return ParticleTypes.SPLASH;
    }

    protected SoundEvent getSwimSound() {
        return SoundEvents.FISH_SWIM;
    }

    public boolean fromBucket() {
        return this.fromBucket;
    }

    public void setFromBucket(boolean b) {
        this.fromBucket = b;
    }

    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)ItemRegistry.cauldron_fish_bucket.get());
    }

    public SoundEvent getPickupSound() {
        return SoundEvents.BUCKET_FILL_FISH;
    }

    public void saveToBucketTag(ItemStack stack) {
        Bucketable.saveDefaultDataToBucketTag((Mob)this, (ItemStack)stack);
    }

    public void loadFromBucketTag(CompoundTag tag) {
        Bucketable.loadDefaultDataFromBucketTag((Mob)this, (CompoundTag)tag);
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        return Bucketable.bucketMobPickup((Player)player, (InteractionHand)hand, (LivingEntity)this).orElse(super.mobInteract(player, hand));
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("FromBucket")) {
            this.fromBucket = tag.getBoolean("FromBucket");
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("FromBucket", this.fromBucket);
    }

    public void tick() {
        if (this.level().getRandom().nextInt(10) == 0) {
            List e = this.level().getEntities((Entity)this, new AABB(-25.0, -16.0, -25.0, 25.0, 16.0, 25.0));
            for (Entity entity : e) {
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity ent = (LivingEntity)entity;
                if (entity instanceof EntityCauldronFish || entity instanceof Player && (((Player)entity).isCreative() || ((Player)entity).isSpectator()) || !(entity.position().distanceToSqr(this.position()) < 1.5)) continue;
                ent.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 60, 18, true, false));
            }
        }
        super.tick();
    }
}

