/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.iceika;

import divinerpg.entities.base.EntityDivineFlyingMonster;
import divinerpg.entities.boss.EntityKitra;
import divinerpg.registries.SoundRegistry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.PathType;

public class EntityAlicanto
extends EntityDivineFlyingMonster {
    private int attackTick;

    public EntityAlicanto(EntityType<? extends EntityDivineFlyingMonster> type, Level worldIn) {
        super(type, worldIn, 18.0f);
        this.fallDistance = 0.0f;
        this.setPathfindingMalus(PathType.WATER, -1.0f);
    }

    public void setTarget(LivingEntity entity) {
        super.setTarget((LivingEntity)(entity != null && entity instanceof EntityKitra ? null : entity));
    }

    public void addAdditionalSaveData(CompoundTag p_33353_) {
        super.addAdditionalSaveData(p_33353_);
        p_33353_.putInt("AttackTick", this.attackTick);
    }

    public void readAdditionalSaveData(CompoundTag p_33344_) {
        super.readAdditionalSaveData(p_33344_);
        this.attackTick = p_33344_.getInt("AttackTick");
    }

    public void aiStep() {
        super.aiStep();
        if (this.isAlive() && this.attackTick > 0) {
            --this.attackTick;
        }
    }

    public void handleEntityEvent(byte p_33335_) {
        if (p_33335_ == 4) {
            this.attackTick = 10;
        }
        super.handleEntityEvent(p_33335_);
    }

    public int getAttackTick() {
        return this.attackTick;
    }

    public boolean doHurtTarget(Entity p_33328_) {
        this.attackTick = 10;
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        return super.doHurtTarget(p_33328_);
    }

    public int getMaxSpawnClusterSize() {
        return 2;
    }

    public boolean isMaxGroupSizeReached(int i) {
        return i > 2;
    }

    public float getVoicePitch() {
        return super.getVoicePitch() * 0.95f;
    }

    protected SoundEvent getAmbientSound() {
        return this.random.nextInt(4) != 0 ? null : (SoundEvent)SoundRegistry.ALICANTO.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SoundRegistry.ALICANTO_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.ALICANTO_HURT.get();
    }
}

