/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.goals.miner;

import divinerpg.entities.vanilla.overworld.EntityMiner;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;

public class MoveToItemGoal
extends Goal {
    private final EntityMiner miner;
    private ItemEntity targetItem;
    private final double speed;

    public MoveToItemGoal(EntityMiner miner, double speed) {
        this.miner = miner;
        this.speed = speed;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        ItemEntity closestItem = this.miner.level().getEntitiesOfClass(ItemEntity.class, this.miner.getBoundingBox().inflate(5.0)).stream().min((item1, item2) -> Double.compare(this.miner.distanceTo((Entity)item1), this.miner.distanceTo((Entity)item2))).orElse(null);
        if (closestItem != null && (double)this.miner.distanceTo((Entity)closestItem) > 1.0) {
            this.targetItem = closestItem;
            return true;
        }
        return false;
    }

    public void start() {
        this.miner.getNavigation().moveTo((Entity)this.targetItem, this.speed);
    }

    public boolean canContinueToUse() {
        return this.targetItem != null && (double)this.miner.distanceTo((Entity)this.targetItem) > 1.0 && !this.miner.getNavigation().isDone();
    }

    public void stop() {
        if (this.targetItem != null) {
            this.miner.pickUpDroppedItem(this.targetItem);
        }
    }
}

