/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.goals.miner;

import divinerpg.entities.vanilla.overworld.EntityMiner;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.block.Blocks;

public class MoveToChestGoal
extends Goal {
    private final EntityMiner miner;
    private BlockPos chestLocation = null;
    private final double speed;

    public MoveToChestGoal(EntityMiner miner, double speed) {
        this.miner = miner;
        this.speed = speed;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (this.chestLocation == null) {
            this.chestLocation = this.findNearestChest();
        }
        return this.chestLocation != null && this.miner.distanceToSqr((double)this.chestLocation.getX() + 0.5, (double)this.chestLocation.getY() + 0.5, (double)this.chestLocation.getZ() + 0.5) > 2.0;
    }

    public void start() {
        if (this.chestLocation != null) {
            this.miner.getNavigation().moveTo((double)this.chestLocation.getX() + 0.5, (double)this.chestLocation.getY() + 0.5, (double)this.chestLocation.getZ() + 0.5, this.speed);
        }
    }

    private BlockPos findNearestChest() {
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        BlockPos origin = this.miner.blockPosition();
        int searchRadius = 8;
        for (int x = -searchRadius; x <= searchRadius; ++x) {
            for (int z = -searchRadius; z <= searchRadius; ++z) {
                for (int y = -5; y <= 5; ++y) {
                    checkPos.set(origin.getX() + x, origin.getY() + y, origin.getZ() + z);
                    if (!this.miner.level().getBlockState((BlockPos)checkPos).is(Blocks.CHEST)) continue;
                    return checkPos.immutable();
                }
            }
        }
        return null;
    }
}

