/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.goals.miner;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class FindOreGoal
extends Goal {
    private final Monster miner;
    private final double speedModifier;
    private BlockPos targetOrePos;
    private BlockPos chestPos;
    private int miningTime;
    private boolean isStuck;
    private boolean isMiningTunnel;
    private BlockPos tunnelTargetPos;
    private static final double REACH_DISTANCE = 4.9;

    public FindOreGoal(Monster miner, double speedModifier, BlockPos chestPos) {
        this.miner = miner;
        this.speedModifier = Math.max(speedModifier, 0.5);
        this.chestPos = chestPos;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.miner.getTarget() != null || !this.miner.isAlive()) {
            return false;
        }
        this.targetOrePos = this.findClosestOre();
        return this.targetOrePos != null || this.chestPos != null && this.isStuck;
    }

    public boolean canContinueToUse() {
        return this.targetOrePos != null && this.miner.level().getBlockState(this.targetOrePos).is(BlockTags.create((ResourceLocation)ResourceLocation.parse((String)"c:ores"))) || this.isMiningTunnel;
    }

    public void start() {
        this.isStuck = false;
        this.isMiningTunnel = false;
        this.moveToTargetOre();
    }

    public void stop() {
        this.miner.getNavigation().stop();
        this.targetOrePos = null;
        this.miningTime = 0;
        this.isMiningTunnel = false;
        this.isStuck = false;
    }

    public void tick() {
        if (this.targetOrePos != null) {
            double distanceToOre = this.miner.position().distanceTo(Vec3.atCenterOf((Vec3i)this.targetOrePos));
            double horizontalDistance = Math.sqrt(Math.pow((double)this.targetOrePos.getX() - this.miner.position().x, 2.0) + Math.pow((double)this.targetOrePos.getZ() - this.miner.position().z, 2.0));
            double verticalDistance = Math.abs((double)this.targetOrePos.getY() - this.miner.position().y);
            if (distanceToOre < 4.9) {
                this.mineOre(this.targetOrePos);
            } else if (!this.miner.getNavigation().isInProgress()) {
                this.isStuck = this.checkIfStuck();
                if (this.isStuck) {
                    this.targetOrePos = null;
                    this.tunnelTargetPos = this.chestPos;
                    this.startTunnelMining();
                } else {
                    this.moveToTargetOre();
                }
            }
        } else if (this.isMiningTunnel) {
            this.mineTunnel();
        }
        if (this.isStuck) {
            this.tryToEscape();
        }
    }

    private boolean checkIfStuck() {
        BlockPos minerPos = this.miner.blockPosition();
        int freeSpaceCount = 0;
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos checkPos = minerPos.offset(x, y, z);
                    if (!this.miner.level().getBlockState(checkPos).isAir()) continue;
                    ++freeSpaceCount;
                }
            }
        }
        boolean hasFreeSpaceAbove = this.miner.level().getBlockState(minerPos.above()).isAir();
        return freeSpaceCount < 5 && hasFreeSpaceAbove;
    }

    private void moveToTargetOre() {
        if (this.targetOrePos != null) {
            this.miner.getNavigation().moveTo((double)this.targetOrePos.getX(), (double)this.targetOrePos.getY(), (double)this.targetOrePos.getZ(), this.speedModifier);
        }
    }

    private void startTunnelMining() {
        if (this.tunnelTargetPos != null) {
            this.isMiningTunnel = true;
        }
    }

    private void mineTunnel() {
        BlockPos minerPos = this.miner.blockPosition();
        Vec3 direction = Vec3.atLowerCornerOf((Vec3i)this.tunnelTargetPos.subtract((Vec3i)minerPos)).normalize();
        int dx = (int)Math.signum(direction.x);
        int dy = (int)Math.signum(direction.y);
        int dz = (int)Math.signum(direction.z);
        BlockPos nextPos = minerPos.offset(dx, dy, dz);
        if (this.miner.level().getBlockState(nextPos).isAir()) {
            this.miner.getNavigation().moveTo(Vec3.atCenterOf((Vec3i)nextPos).x, Vec3.atCenterOf((Vec3i)nextPos).y, Vec3.atCenterOf((Vec3i)nextPos).z, this.speedModifier);
        } else {
            this.mineBlock(nextPos);
        }
    }

    private void mineOre(BlockPos pos) {
        if (this.miner.level().getBlockState(pos).is(BlockTags.create((ResourceLocation)ResourceLocation.parse((String)"c:ores")))) {
            Block block = this.miner.level().getBlockState(pos).getBlock();
            float hardness = block.defaultDestroyTime();
            boolean hasLineOfSight = this.hasClearLineOfSight(pos);
            if (!hasLineOfSight) {
                return;
            }
            double verticalOffset = (double)pos.getY() - this.miner.getEyePosition().y;
            if (verticalOffset > 4.9) {
                return;
            }
            if (verticalOffset > 1.0) {
                this.miner.getLookControl().setLookAt((double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5);
            }
            if ((float)this.miningTime < hardness * 10.0f) {
                ++this.miningTime;
                this.miner.swing(InteractionHand.MAIN_HAND);
                this.miner.level().levelEvent(2001, pos, Block.getId((BlockState)this.miner.level().getBlockState(pos)));
            } else {
                Block.dropResources((BlockState)this.miner.level().getBlockState(pos), (Level)this.miner.level(), (BlockPos)pos, null, (Entity)this.miner, (ItemStack)this.miner.getMainHandItem());
                this.miner.level().setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                this.miningTime = 0;
            }
        }
    }

    private void mineBlock(BlockPos pos) {
        double distanceToBlock = this.miner.getEyePosition().distanceTo(Vec3.atCenterOf((Vec3i)pos));
        if (!this.miner.level().getBlockState(pos).isAir()) {
            Block block = this.miner.level().getBlockState(pos).getBlock();
            float hardness = block.defaultDestroyTime();
            double verticalOffset = (double)pos.getY() - this.miner.getEyePosition().y;
            if (verticalOffset > 4.9) {
                return;
            }
            if ((float)this.miningTime < hardness * 10.0f) {
                ++this.miningTime;
                this.miner.swing(InteractionHand.MAIN_HAND);
                this.miner.level().levelEvent(2001, pos, Block.getId((BlockState)this.miner.level().getBlockState(pos)));
            } else {
                this.miner.level().setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                this.miningTime = 0;
            }
        }
    }

    private void tryToEscape() {
        BlockPos minerPos = this.miner.blockPosition();
        int yOffset = 1;
        while ((double)yOffset <= 4.9) {
            BlockPos abovePos = minerPos.above(yOffset);
            boolean isAir = this.miner.level().getBlockState(abovePos).isAir();
            if (isAir) {
                Block blockToPlace = Blocks.COBBLESTONE;
                this.miner.level().setBlock(minerPos, blockToPlace.defaultBlockState(), 3);
                this.miner.jumpFromGround();
                this.isStuck = false;
                break;
            }
            this.mineBlock(abovePos);
            ++yOffset;
        }
    }

    private BlockPos findClosestOre() {
        double searchRadius = this.miner.getAttribute(Attributes.FOLLOW_RANGE).getValue();
        List<BlockPos> nearbyOres = this.getNearbyBlocks((Entity)this.miner, (TagKey<Block>)BlockTags.create((ResourceLocation)ResourceLocation.parse((String)"c:ores")), searchRadius);
        if (nearbyOres.isEmpty()) {
            return null;
        }
        return nearbyOres.stream().filter(this::isValidTargetOre).min(Comparator.comparingDouble(ore -> this.miner.distanceToSqr((double)ore.getX(), (double)ore.getY(), (double)ore.getZ()))).orElse(null);
    }

    private List<BlockPos> getNearbyBlocks(Entity entity, TagKey<Block> blockTag, double searchRadius) {
        Level level = entity.level();
        BlockPos entityPos = entity.blockPosition();
        ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
        int minX = (int)Math.floor((double)entityPos.getX() - searchRadius);
        int maxX = (int)Math.ceil((double)entityPos.getX() + searchRadius);
        int minY = (int)Math.max((double)entityPos.getY() - searchRadius, (double)level.getMinBuildHeight());
        int maxY = (int)Math.min((double)entityPos.getY() + searchRadius, (double)level.getMaxBuildHeight());
        int minZ = (int)Math.floor((double)entityPos.getZ() - searchRadius);
        int maxZ = (int)Math.ceil((double)entityPos.getZ() + searchRadius);
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    if (!level.getBlockState(pos).is(blockTag)) continue;
                    blocks.add(pos);
                }
            }
        }
        return blocks;
    }

    private boolean isValidTargetOre(BlockPos pos) {
        return this.miner.level().getBlockState(pos).is(BlockTags.create((ResourceLocation)ResourceLocation.parse((String)"c:ores")));
    }

    private boolean hasClearLineOfSight(BlockPos pos) {
        Vec3 minerEyePos = this.miner.getEyePosition();
        Vec3 blockCenterPos = Vec3.atCenterOf((Vec3i)pos);
        BlockHitResult hitResult = this.miner.level().clip(new ClipContext(minerEyePos, blockCenterPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.miner));
        return hitResult.getBlockPos().equals((Object)pos);
    }
}

