/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.goals;

import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.pathfinder.PathType;

public class FollowLeaderGoal
extends Goal {
    protected final Mob mob;
    protected final Class<? extends Mob> leader;
    protected final double speedModifier;
    protected final float stopDistance;
    protected final float areaSize;
    protected final Predicate<LivingEntity> followPredicate;
    protected final PathNavigation navigation;
    protected final TargetingConditions conditions;
    @Nullable
    protected Mob following;
    protected int timetorecalcpath;
    protected float oldWaterCost;

    public FollowLeaderGoal(Mob mob, Class<? extends Mob> leader, double speedModifier, float stopDistance, float areaSize) {
        this.mob = mob;
        this.leader = leader;
        this.speedModifier = speedModifier;
        this.stopDistance = stopDistance;
        this.areaSize = areaSize;
        this.followPredicate = entity -> entity != null && entity.getClass() == leader;
        this.navigation = mob.getNavigation();
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.conditions = TargetingConditions.forNonCombat().range((double)areaSize).selector(this.followPredicate);
    }

    public boolean canUse() {
        this.following = (Mob)this.mob.level().getNearestEntity(this.leader, this.conditions, (LivingEntity)this.mob, (double)this.stopDistance, this.speedModifier, (double)this.areaSize, this.mob.getBoundingBox().inflate((double)this.areaSize));
        return this.following != null;
    }

    public boolean canContinueToUse() {
        return this.following != null && !this.navigation.isDone() && this.mob.distanceToSqr((Entity)this.following) > (double)(this.stopDistance * this.stopDistance);
    }

    public void start() {
        this.timetorecalcpath = 0;
        this.oldWaterCost = this.mob.getPathfindingMalus(PathType.WATER);
        this.mob.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    public void stop() {
        this.following = null;
        this.navigation.stop();
        this.mob.setPathfindingMalus(PathType.WATER, this.oldWaterCost);
    }

    public void tick() {
        if (this.following != null && !this.mob.isLeashed()) {
            this.mob.getLookControl().setLookAt((Entity)this.following, 10.0f, (float)this.mob.getMaxHeadXRot());
            if (--this.timetorecalcpath <= 0) {
                double dz;
                double dy;
                this.timetorecalcpath = this.adjustedTickDelay(10);
                double dx = this.mob.getX() - this.following.getX();
                double dsquared = dx * dx + (dy = this.mob.getY() - this.following.getY()) * dy + (dz = this.mob.getZ() - this.following.getZ()) * dz;
                if (dsquared > (double)(this.stopDistance * this.stopDistance)) {
                    this.navigation.moveTo((Entity)this.following, this.speedModifier);
                } else {
                    this.navigation.stop();
                    LookControl lookcontrol = this.following.getLookControl();
                    if (dsquared <= (double)this.stopDistance || lookcontrol.getWantedX() == this.mob.getX() && lookcontrol.getWantedY() == this.mob.getY() && lookcontrol.getWantedZ() == this.mob.getZ()) {
                        this.navigation.moveTo(this.mob.getX() + dx, this.mob.getY(), this.mob.getZ() + dz, this.speedModifier);
                    }
                }
            }
        }
    }
}

