/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.goals;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class EscapeWaterGoal
extends Goal {
    private final LivingEntity entity;
    private Vec3 targetPos;

    public EscapeWaterGoal(LivingEntity entity) {
        this.entity = entity;
    }

    public boolean canUse() {
        if (this.entity.isInWater()) {
            BlockPos.MutableBlockPos pos = this.entity.level().getHeightmapPos(Heightmap.Types.WORLD_SURFACE_WG, this.entity.blockPosition()).mutable();
            this.targetPos = new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
            return true;
        }
        return false;
    }

    public void start() {
        if (this.targetPos != null) {
            ((Mob)this.entity).getNavigation().moveTo(this.targetPos.x, this.targetPos.y, this.targetPos.z, 1.0);
        }
    }

    public boolean canContinueToUse() {
        return this.entity.isInWater();
    }

    public void stop() {
        ((Mob)this.entity).getNavigation().stop();
    }
}

