/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.goals;

import divinerpg.enums.ILaunchFireBall;
import divinerpg.enums.ILaunchThrowable;
import java.util.function.BiFunction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;

public class DivineFireballAttackGoal
extends Goal {
    private final Mob parentEntity;
    private final BiFunction<Mob, Entity, Entity> createFireballFunc;
    public int attackTimer;
    private final int attackDelay;
    private final int maxDistance;
    private final SoundEvent beforeShoot;
    private final SoundEvent onShoot;

    public DivineFireballAttackGoal(Mob parentEntity, BiFunction<Mob, Entity, Entity> createFireballFunc, int attackDelay, int maxDistance, SoundEvent beforeShoot, SoundEvent onShoot) {
        this.parentEntity = parentEntity;
        this.createFireballFunc = createFireballFunc;
        this.attackDelay = attackDelay;
        this.maxDistance = maxDistance;
        this.beforeShoot = beforeShoot;
        this.onShoot = onShoot;
    }

    public DivineFireballAttackGoal(Mob ghast, ILaunchFireBall func) {
        this(ghast, func::createFireball, 20, 64, SoundEvents.GHAST_WARN, SoundEvents.GHAST_SHOOT);
    }

    public DivineFireballAttackGoal(Mob ghast, ILaunchFireBall createFireball, SoundEvent onShoot) {
        this(ghast, createFireball::createFireball, 20, 64, null, onShoot);
    }

    public DivineFireballAttackGoal(Mob ghast, ILaunchThrowable createThrowable, SoundEvent onShoot) {
        this(ghast, createThrowable::createFireball, 20, 64, null, onShoot);
    }

    public boolean canContinueToUse() {
        return super.canContinueToUse();
    }

    public void start() {
        this.attackTimer = 0;
    }

    public void stop() {
    }

    public void tick() {
        LivingEntity entitylivingbase;
        if (this.parentEntity != null && (entitylivingbase = this.parentEntity.getTarget()) != null) {
            if (Math.sqrt(entitylivingbase.distanceTo((Entity)this.parentEntity)) < (double)this.maxDistance && this.parentEntity.hasLineOfSight((Entity)entitylivingbase)) {
                Level world = this.parentEntity.level();
                ++this.attackTimer;
                if (this.attackTimer == this.attackDelay - 10) {
                    this.playSound(this.beforeShoot);
                }
                if (this.attackTimer == this.attackDelay) {
                    this.playSound(this.onShoot);
                    world.addFreshEntity(this.createFireballFunc.apply(this.parentEntity, (Entity)entitylivingbase));
                    this.attackTimer = this.attackDelay * -2;
                }
            } else if (this.attackTimer > 0) {
                --this.attackTimer;
            }
            if (this.attackTimer <= 10) {
                // empty if block
            }
        }
    }

    public boolean canUse() {
        return this.parentEntity.getLastHurtByMob() != null;
    }

    private void playSound(SoundEvent event) {
        if (this.parentEntity == null || this.parentEntity.level() == null || event == null) {
            return;
        }
        RandomSource rand = this.parentEntity.level().getRandom();
        this.parentEntity.level().playSound(null, this.parentEntity.blockPosition(), event, SoundSource.HOSTILE, 10.0f, (rand.nextFloat() - rand.nextFloat()) * 0.2f + 1.0f);
    }
}

