/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.goals;

import divinerpg.entities.base.FactionEntity;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class AvoidFactionGoal
extends Goal {
    protected final PathfinderMob mob;
    protected final FactionEntity.Faction myFaction;
    protected final float maxDist;
    protected final double walkSpeedModifier;
    protected final double sprintSpeedModifier;
    protected final TargetingConditions avoidingConditions;
    @Nullable
    protected LivingEntity toAvoid;
    @Nullable
    protected Path path;
    protected final PathNavigation pathNav;

    public AvoidFactionGoal(PathfinderMob mob, FactionEntity.Faction myFaction, float maxDist, double walkSpeedModifier, double sprintSpeedModifier) {
        this.mob = mob;
        this.myFaction = myFaction;
        this.maxDist = maxDist;
        this.walkSpeedModifier = walkSpeedModifier;
        this.sprintSpeedModifier = sprintSpeedModifier;
        this.pathNav = mob.getNavigation();
        this.avoidingConditions = TargetingConditions.forCombat().range((double)maxDist);
    }

    public boolean canUse() {
        this.toAvoid = FactionEntity.Faction.getNearestEnemy((LivingEntity)this.mob, this.getTargetSearchArea(this.maxDist), this.avoidingConditions);
        if (this.toAvoid == null) {
            return false;
        }
        Vec3 vec3 = DefaultRandomPos.getPosAway((PathfinderMob)this.mob, (int)16, (int)7, (Vec3)this.toAvoid.position());
        if (vec3 == null || this.toAvoid.distanceToSqr(vec3) < this.toAvoid.distanceToSqr((Entity)this.mob)) {
            return false;
        }
        this.path = this.pathNav.createPath(vec3.x, vec3.y, vec3.z, 0);
        return this.path != null;
    }

    protected AABB getTargetSearchArea(double distance) {
        return this.mob.getBoundingBox().inflate(distance, distance / 2.0, distance);
    }

    public boolean canContinueToUse() {
        return !this.pathNav.isDone();
    }

    public void start() {
        this.pathNav.moveTo(this.path, this.walkSpeedModifier);
    }

    public void stop() {
        this.toAvoid = null;
    }

    public void tick() {
        this.mob.getNavigation().setSpeedModifier(this.mob.distanceToSqr((Entity)this.toAvoid) < 49.0 ? this.sprintSpeedModifier : this.walkSpeedModifier);
    }
}

