/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.eden;

import divinerpg.registries.AttachmentRegistry;
import divinerpg.registries.BlockRegistry;
import divinerpg.registries.ItemRegistry;
import divinerpg.util.LocalizeUtils;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class EntityGemFin
extends AbstractSchoolingFish {
    private boolean hasBeenFed = false;

    public EntityGemFin(EntityType<? extends EntityGemFin> type, Level level) {
        super(type, level);
        if (!level.isClientSide()) {
            AttachmentRegistry.VARIANT.setSilent((Entity)this, (byte)this.getRandom().nextInt(3));
        }
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        if (this.level().isClientSide()) {
            AttachmentRegistry.VARIANT.requestAttachment((Entity)this, null);
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("HasBeenFed", this.isFed());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("HasBeenFed")) {
            this.setFed(compound.getBoolean("HasBeenFed"));
        }
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack heldItem = player.getItemInHand(hand);
        if (!this.hasBeenFed && heldItem.getItem() == ((Block)BlockRegistry.gemOfTheDunes.get()).asItem()) {
            heldItem.consume(1, (LivingEntity)player);
            this.setFed(true);
            for (int i = 0; i < 7; ++i) {
                double d0 = this.random.nextGaussian() * 0.02;
                double d1 = this.random.nextGaussian() * 0.02;
                double d2 = this.random.nextGaussian() * 0.02;
                this.level().addParticle((ParticleOptions)ParticleTypes.HEART, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), d0, d1, d2);
            }
            return InteractionResult.SUCCESS;
        }
        if (heldItem.getItem() == Items.WATER_BUCKET && this.isAlive()) {
            Bucketable.bucketMobPickup((Player)player, (InteractionHand)hand, (LivingEntity)this);
            return InteractionResult.SUCCESS;
        }
        if (!this.hasBeenFed && heldItem.getItem() != ((Block)BlockRegistry.gemOfTheDunes.get()).asItem() && heldItem.getItem() != Items.WATER_BUCKET) {
            player.displayClientMessage(LocalizeUtils.clientMessage("feed_gem", new Object[0]), true);
            return InteractionResult.CONSUME;
        }
        if (this.hasBeenFed && heldItem.getItem() == ((Block)BlockRegistry.gemOfTheDunes.get()).asItem()) {
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return !this.hasBeenFed;
    }

    public void saveToBucketTag(ItemStack stack) {
        super.saveToBucketTag(stack);
        CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)stack, tag -> tag.putByte("Variant", this.getVariant()));
    }

    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)ItemRegistry.gem_fin_bucket.get());
    }

    public void setFed(boolean bool) {
        this.hasBeenFed = bool;
    }

    public boolean isFed() {
        return this.hasBeenFed;
    }

    public byte getVariant() {
        return (Byte)AttachmentRegistry.VARIANT.get((Entity)this);
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.COD_AMBIENT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.COD_DEATH;
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.COD_HURT;
    }

    protected SoundEvent getFlopSound() {
        return SoundEvents.COD_FLOP;
    }
}

