/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.boss;

import divinerpg.entities.base.EntityDivineBoss;
import divinerpg.entities.projectile.DivineThrowableProjectile;
import divinerpg.entities.projectile.magic.EntityBouncingProjectile;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.SoundRegistry;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class EntityWreck
extends EntityDivineBoss {
    private static final int MELEE = 0;
    private static final int ARCANA = 1;
    private static final int RANGED = 2;
    private static final int DEFAULT = 0;
    private static final int CHARGE = 1;
    private static final int PULL = 2;
    private static final int FIRE = 3;
    private static final int BOUNCE = 4;
    private static final int FREEZE = 5;
    private static final int SPEED = 6;
    private static final int EXPLOSIONS = 7;
    private static final int STRENGTH = 8;
    private int abilityTimer;
    private boolean loaded = false;
    private int ability;
    private int abilityType;

    public EntityWreck(EntityType<? extends EntityWreck> type, Level worldIn) {
        super((EntityType<? extends EntityDivineBoss>)type, worldIn);
    }

    public void manageAbilities() {
        Player player = this.level().getNearestPlayer((Entity)this, 64.0);
        if (this.getHealth() < 341.33334f) {
            this.setAbilityType(2);
        } else if (this.getHealth() < 682.6667f && this.getHealth() > 341.33334f) {
            this.setAbilityType(1);
            this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.1);
            this.setSpeed((float)this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
        } else {
            this.setAbilityType(0);
        }
        if (this.abilityTimer > 0) {
            --this.abilityTimer;
        }
        if (this.getAbilityType() == 1 && (this.getAbility() == 1 || this.getAbility() == 2) || this.getAbilityType() == 2 && (this.getAbility() == 3 || this.getAbility() == 4 || this.getAbility() == 5)) {
            this.setAbility(0);
        }
        if (this.getAbility() == 0 && this.abilityTimer == 0) {
            this.abilityTimer = 200;
            block0 : switch (this.getAbilityType()) {
                case 0: {
                    switch (this.random.nextInt(2)) {
                        case 0: {
                            this.setAbility(2);
                            this.setSpeed(0.0f);
                            this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.32);
                            break block0;
                        }
                        case 1: {
                            this.setAbility(1);
                            this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.5);
                            break block0;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (this.random.nextInt(3)) {
                        case 0: {
                            this.setAbility(3);
                            break block0;
                        }
                        case 1: {
                            this.setAbility(4);
                            break block0;
                        }
                        case 2: {
                            this.setAbility(5);
                            break block0;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (this.random.nextInt(3)) {
                        case 0: {
                            this.setAbility(6);
                            break block0;
                        }
                        case 1: {
                            this.setAbility(7);
                            break block0;
                        }
                        case 2: {
                            this.setAbility(8);
                            break block0;
                        }
                    }
                    break;
                }
            }
            this.message();
        }
        if (this.getAbility() == 1 && this.abilityTimer == 0) {
            this.setAbility(0);
            this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.32);
        }
        if (this.getAbility() == 3 && player != null) {
            for (int i = 1; i < 20; ++i) {
                int var2 = (this.blockPosition().getX() - player.blockPosition().getX()) * i / 5;
                int var3 = (this.blockPosition().getZ() - player.blockPosition().getZ()) * i / 5;
                if (this.level().getBlockState(new BlockPos(this.blockPosition().getX() - var2, this.blockPosition().getY(), this.blockPosition().getZ() - var3)) != Blocks.AIR.defaultBlockState()) continue;
                this.level().setBlock(new BlockPos(this.blockPosition().getX() - var2, this.blockPosition().getY(), this.blockPosition().getZ() - var3), Blocks.FIRE.defaultBlockState(), 0);
            }
            this.setAbility(0);
        }
        if (this.getAbility() == 5 && player != null) {
            player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 100, 5));
            this.setAbility(0);
            this.abilityTimer = 100;
        }
        if (!this.level().isClientSide()) {
            this.performRangedAttack();
        }
    }

    private void message() {
        List list = this.level().getEntities((Entity)this, this.getBoundingBox().expandTowards(64.0, 64.0, 64.0));
        for (Entity entity : list) {
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            switch (this.getAbility()) {
                case 1: {
                    player.displayClientMessage(LocalizeUtils.getClientSideTranslation("message.wreck.charge", new Object[0]), true);
                    break;
                }
                case 2: {
                    this.playSound((SoundEvent)SoundRegistry.FEEL_SOUL_ARKSIANE.get(), 1.0f, 1.0f);
                    if (this.level().isClientSide()) break;
                    player.displayClientMessage(LocalizeUtils.getClientSideTranslation("message.wreck.pull", new Object[0]), true);
                    break;
                }
                case 3: {
                    player.displayClientMessage(LocalizeUtils.getClientSideTranslation("message.wreck.fire", new Object[0]), true);
                    break;
                }
                case 5: {
                    this.playSound((SoundEvent)SoundRegistry.STOP_AT_ONCE.get(), 1.0f, 1.0f);
                    if (this.level().isClientSide()) break;
                    player.displayClientMessage(LocalizeUtils.getClientSideTranslation("message.wreck.freeze", new Object[0]), true);
                    break;
                }
                case 6: {
                    this.playSound((SoundEvent)SoundRegistry.WRECK_SPEED.get(), 1.0f, 1.0f);
                    if (this.level().isClientSide()) break;
                    player.displayClientMessage(LocalizeUtils.getClientSideTranslation("message.wreck.speed", new Object[0]), true);
                    break;
                }
                case 7: {
                    this.playSound((SoundEvent)SoundRegistry.EXPLOSIONS.get(), 1.0f, 1.0f);
                    if (this.level().isClientSide()) break;
                    player.displayClientMessage(LocalizeUtils.getClientSideTranslation("message.wreck.explosion", new Object[0]), true);
                    break;
                }
                case 8: {
                    this.playSound((SoundEvent)SoundRegistry.WRECK_STRENGTH.get(), 1.0f, 1.0f);
                    if (this.level().isClientSide()) break;
                    player.displayClientMessage(LocalizeUtils.getClientSideTranslation("message.wreck.strength", new Object[0]), true);
                    break;
                }
            }
        }
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide() && !this.loaded) {
            List players = this.level().getEntitiesOfClass(Player.class, this.getBoundingBox().expandTowards(30.0, 30.0, 30.0));
            for (Player p : players) {
                p.displayClientMessage(LocalizeUtils.getClientSideTranslation("message.wreck.run", new Object[0]), true);
                p.displayClientMessage(LocalizeUtils.getClientSideTranslation("message.wreck.smell", new Object[0]), true);
            }
            this.playSound((SoundEvent)SoundRegistry.WRECK_INTRO.get(), 1.0f, 1.0f);
            this.loaded = true;
        }
        if (this.isAlive()) {
            Player player = this.level().getNearestPlayer((Entity)this, 64.0);
            if (this.getAbility() == 2 && player != null && !player.isCreative()) {
                player.setDeltaMovement((this.getX() - player.getX()) * 0.069, (this.getY() - player.getY()) * 0.069, (this.getZ() - player.getZ()) * 0.069);
            }
            this.manageAbilities();
        }
    }

    public boolean doHurtTarget(Entity par1Entity) {
        if (this.getAbilityType() != 0) {
            return false;
        }
        float amount = (float)this.getAttribute(Attributes.ATTACK_DAMAGE).getValue();
        int knockback = 0;
        boolean var4 = par1Entity.hurt(par1Entity.level().damageSources().mobAttack((LivingEntity)this), amount);
        if (var4) {
            int var5;
            if (this.getAbility() == 2) {
                this.setAbility(1);
                this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.25);
                this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.5);
                knockback = 2;
            }
            if (knockback > 0) {
                par1Entity.setDeltaMovement((double)(-Mth.sin((float)(this.getXRot() * (float)Math.PI / 180.0f)) * (float)knockback * 0.5f), 0.1, (double)(Mth.cos((float)(this.getYRot() * (float)Math.PI / 180.0f)) * (float)knockback * 0.5f));
                this.setDeltaMovement(this.getDeltaMovement().x * 0.6, this.getDeltaMovement().y, this.getDeltaMovement().z * 0.6);
            }
            if ((var5 = EnchantmentHelper.getEnchantmentLevel((Holder)this.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.FIRE_ASPECT), (LivingEntity)this)) > 0) {
                par1Entity.igniteForSeconds((float)(var5 * 4));
            }
        }
        return var4;
    }

    public void performRangedAttack() {
        if (!this.isAlive() || this.getTarget() == null || this.level().isClientSide()) {
            return;
        }
        double x = this.getTarget().getX() - this.getX();
        double z = this.getTarget().getZ() - this.getZ();
        switch (this.getAbility()) {
            case 4: {
                EntityBouncingProjectile projectile = (EntityBouncingProjectile)((EntityType)EntityRegistry.BOUNCING_PROJECTILE.get()).create(this.level());
                projectile.setOwner((Entity)this);
                projectile.setPos(this.getEyePosition());
                projectile.baseDamage = 35.0f;
                double bounceY = this.getTarget().getY(0.3333333333333333) - projectile.getY();
                double d3 = Mth.sqrt((float)((float)(x * x + z * z)));
                projectile.shoot(x, bounceY + d3 * (double)0.2f, z, 1.6f, 0.5f);
                this.level().addFreshEntity((Entity)projectile);
                this.setAbility(0);
                break;
            }
            case 6: {
                if (this.abilityTimer % 5 == 0) {
                    ThrowableProjectile shot = (ThrowableProjectile)((EntityType)EntityRegistry.WRECK_SHOT.get()).create(this.level());
                    shot.setPos(this.getEyePosition());
                    shot.setOwner((Entity)this);
                    double shotY = this.getTarget().getY(0.3333333333333333) - shot.getY();
                    double ws3 = Mth.sqrt((float)((float)(x * x + z * z)));
                    shot.shoot(x, shotY + ws3 * (double)0.2f, z, 1.6f, 0.5f);
                    this.level().addFreshEntity((Entity)shot);
                }
                if (this.abilityTimer > 100) break;
                this.setAbility(0);
                break;
            }
            case 7: {
                if (this.abilityTimer % 40 == 0) {
                    ThrowableProjectile explosiveShot = (ThrowableProjectile)((EntityType)EntityRegistry.WRECK_BOMB.get()).create(this.level());
                    explosiveShot.setOwner((Entity)this);
                    explosiveShot.setPos(this.getEyePosition());
                    double explodeY = this.getTarget().getY(0.3333333333333333) - explosiveShot.getY();
                    double e3 = Mth.sqrt((float)((float)(x * x + z * z)));
                    explosiveShot.shoot(x, explodeY + e3 * (double)0.2f, z, 1.6f, 0.5f);
                    this.level().addFreshEntity((Entity)explosiveShot);
                    explosiveShot.shoot(x, explodeY + e3 * (double)0.2f, z, 1.6f, 0.5f);
                    this.level().addFreshEntity((Entity)explosiveShot);
                }
                if (this.abilityTimer != 0) break;
                this.setAbility(0);
                break;
            }
            case 8: {
                if (this.abilityTimer % 40 == 0) {
                    DivineThrowableProjectile strengthShot = (DivineThrowableProjectile)((EntityType)EntityRegistry.WRECK_SHOT.get()).create(this.level());
                    strengthShot.setOwner((Entity)this);
                    strengthShot.setPos(this.getEyePosition());
                    strengthShot.baseDamage = 40.0f;
                    double strengthY = this.getTarget().getY(0.3333333333333333) - strengthShot.getY();
                    double s3 = Mth.sqrt((float)((float)(x * x + z * z)));
                    strengthShot.shoot(x, strengthY + s3 * (double)0.2f, z, 1.6f, 0.5f);
                }
                if (this.abilityTimer != 0) break;
                this.setAbility(0);
                break;
            }
        }
    }

    public int getAbilityType() {
        return this.abilityType;
    }

    public void setAbilityType(int type) {
        this.abilityType = type;
    }

    public int getAbility() {
        return this.ability;
    }

    public void setAbility(int ability) {
        this.ability = ability;
    }

    @Override
    protected void registerGoals() {
        this.targetSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.targetSelector.addGoal(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.targetSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(8, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.targetSelector.addGoal(8, (Goal)new FollowMobGoal((Mob)this, 1.0, 1.0f, 1.0f));
        this.goalSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Piglin.class}));
        this.goalSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public int getMaxSpawnClusterSize() {
        return 3;
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return super.getAmbientSound();
    }
}

