/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.boss;

import divinerpg.entities.base.EntityDivineBoss;
import divinerpg.entities.goals.SunstormAttackGoal;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.SoundRegistry;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;

public class EntitySunstorm
extends EntityDivineBoss
implements RangedAttackMob {
    public EntitySunstorm(EntityType<? extends EntitySunstorm> type, Level worldIn) {
        super((EntityType<? extends EntityDivineBoss>)type, worldIn);
        this.xpReward = 50;
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        if (this.isAlive() && this.getTarget() != null && !this.level().isClientSide && this.canAttack(target)) {
            if (this.distanceTo((Entity)target) < 3.0f) {
                target.igniteForSeconds(3.0f);
            }
            ThrowableProjectile projectile = (ThrowableProjectile)((EntityType)EntityRegistry.SUNSTORM_SHOT.get()).create(this.level());
            projectile.setOwner((Entity)this);
            projectile.setPos(this.getEyePosition());
            double tx = this.getTarget().getX() - this.getX();
            double ty = this.getTarget().getEyeY() - this.getEyeY();
            double tz = this.getTarget().getZ() - this.getZ();
            double horizontalDistance = Math.sqrt(tx * tx + tz * tz);
            projectile.shoot(tx, ty, tz, 1.6f, 0.0f);
            projectile.setDeltaMovement(tx / horizontalDistance * (double)1.6f, ty / horizontalDistance * (double)1.6f, tz / horizontalDistance * (double)1.6f);
            this.level().addFreshEntity((Entity)projectile);
        }
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(0, (Goal)new SunstormAttackGoal(this, 0.27f, 50, 10.0f));
        this.targetSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 0, true, false, null));
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.SPARKLER.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.FIRE_EXTINGUISH;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.ZOMBIE_VILLAGER_CURE;
    }
}

