/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.boss;

import divinerpg.entities.base.EntityDivineBoss;
import divinerpg.entities.projectile.bullet.EntitySoulFiendShot;
import divinerpg.registries.EntityRegistry;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class EntitySoulFiend
extends EntityDivineBoss {
    public EntitySoulFiend(EntityType<? extends EntitySoulFiend> type, Level worldIn) {
        super((EntityType<? extends EntityDivineBoss>)type, worldIn);
    }

    public int getArmorValue() {
        return 10;
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide() && this.tickCount % 300 == 0) {
            for (int i = 0; i < 4; ++i) {
                EntitySoulFiendShot shot = (EntitySoulFiendShot)((EntityType)EntityRegistry.SOUL_FIEND_SHOT.get()).create(this.level());
                shot.setOwner((Entity)this);
                shot.setPos(this.position());
                shot.shoot(this.random.nextDouble() - this.random.nextDouble(), -0.25, this.random.nextDouble() - this.random.nextDouble(), 0.5f, 12.0f);
                this.level().addFreshEntity((Entity)shot);
            }
        }
    }

    public boolean doHurtTarget(Entity entity) {
        if (super.doHurtTarget(entity)) {
            if (entity instanceof Player) {
                ((LivingEntity)entity).addEffect(new MobEffectInstance(MobEffects.CONFUSION, 240, 0));
                ((LivingEntity)entity).addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 240, 0));
            }
            entity.setDeltaMovement((double)(-Mth.sin((float)(this.getXRot() * (float)Math.PI / 180.0f))) * 2.5, 0.4, (double)Mth.cos((float)(this.getXRot() * (float)Math.PI / 180.0f)) * 2.5);
            this.setDeltaMovement(this.getDeltaMovement().x * 0.6, this.getDeltaMovement().y, this.getDeltaMovement().z * 0.6);
            return true;
        }
        return false;
    }
}

