/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.boss;

import divinerpg.entities.base.EntityDivineBoss;
import divinerpg.entities.projectile.arrows.PardimalArrow;
import divinerpg.registries.ItemRegistry;
import divinerpg.registries.SoundRegistry;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class EntityQuadro
extends EntityDivineBoss
implements RangedAttackMob {
    private QuadroAbility ability = this.getRandomAbility();
    private int abilityCooldown;
    private int rangedAttackCounter;
    public boolean dir;

    public EntityQuadro(EntityType<? extends EntityQuadro> type, Level worldIn) {
        super((EntityType<? extends EntityDivineBoss>)type, worldIn);
    }

    @Override
    protected void registerGoals() {
        this.targetSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.targetSelector.addGoal(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.targetSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(8, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.targetSelector.addGoal(8, (Goal)new FollowMobGoal((Mob)this, 1.0, 1.0f, 1.0f));
        this.goalSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide() && this.getTarget() != null && this.getTarget() instanceof LivingEntity) {
            this.performRangedAttack(this.getTarget(), 0.0f);
        }
        if (this.abilityCooldown <= 0) {
            this.ability = this.getRandomAbility();
            this.abilityCooldown = 500;
            this.rangedAttackCounter = 0;
            this.dir = true;
            int s = this.random.nextInt(9);
            List players = this.level().getEntitiesOfClass(Player.class, this.getBoundingBox().expandTowards(30.0, 30.0, 30.0));
            for (Player p : players) {
                SoundEvent sound;
                String chatMessage = switch (s) {
                    case 0 -> {
                        sound = (SoundEvent)SoundRegistry.QUADRO_DIE_BEFORE.get();
                        yield "message.quadro.die";
                    }
                    case 1 -> {
                        sound = (SoundEvent)SoundRegistry.QUADRO_ENOUGH.get();
                        yield "message.quadro.enough";
                    }
                    case 2 -> {
                        sound = (SoundEvent)SoundRegistry.QUADRO_INCOMING_PUNCH.get();
                        yield "message.quadro.punch";
                    }
                    case 3 -> {
                        sound = (SoundEvent)SoundRegistry.QUADRO_IS_NEXT.get();
                        yield "message.quadro.next";
                    }
                    case 4 -> {
                        sound = (SoundEvent)SoundRegistry.QUADRO_KILL_MINE.get();
                        yield "message.quadro.mine";
                    }
                    case 5 -> {
                        sound = (SoundEvent)SoundRegistry.QUADRO_MY_KILL.get();
                        yield "message.quadro.kill";
                    }
                    case 6 -> {
                        sound = (SoundEvent)SoundRegistry.QUADRO_NO_DIE.get();
                        yield "message.quadro.no";
                    }
                    case 7 -> {
                        sound = (SoundEvent)SoundRegistry.QUADRO_SIT_DOWN.get();
                        yield "message.quadro.sit";
                    }
                    default -> {
                        sound = (SoundEvent)SoundRegistry.QUADRO_TASTE_FIST.get();
                        yield "message.quadro.taste";
                    }
                };
                this.level().playSound(p, p.blockPosition(), sound, SoundSource.HOSTILE, 1.0f, 1.0f);
                if (this.level().isClientSide()) continue;
                p.displayClientMessage(LocalizeUtils.getClientSideTranslation(chatMessage, new Object[0]), true);
            }
        }
        if (this.abilityCooldown == 480) {
            --this.abilityCooldown;
            this.dir = false;
        }
        if (this.abilityCooldown > 0) {
            --this.abilityCooldown;
        }
        if (this.ability == QuadroAbility.MELEE_SLOW) {
            this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.32);
            this.setSpeed(0.48f);
        } else if (this.ability == QuadroAbility.MELEE_FAST) {
            this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.48);
            this.setSpeed(0.32f);
        } else if (this.ability == QuadroAbility.RANGED_SLOW) {
            this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.0);
            this.setSpeed(0.0f);
        } else if (this.ability == QuadroAbility.RANGED_FAST) {
            this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.0);
            this.setSpeed(0.0f);
        }
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        if (this.getTarget() != null && this.isAlive() && !this.level().isClientSide) {
            switch (this.ability.ordinal()) {
                case 1: {
                    if (this.rangedAttackCounter % 5 == 0) {
                        PardimalArrow abstractarrow = new PardimalArrow(this.level(), (LivingEntity)this, new ItemStack((ItemLike)ItemRegistry.pardimal_arrow.get()), new ItemStack((ItemLike)ItemRegistry.pardimal_bow.get()));
                        abstractarrow.powerMultiplier = 1.2f;
                        double d0 = target.getX() - this.getX();
                        double d1 = target.getY(0.3333333333333333) - abstractarrow.getY();
                        double d2 = target.getZ() - this.getZ();
                        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
                        abstractarrow.shoot(d0, d1 + d3 * 0.2, d2, 1.6f, 14.0f - (float)(this.level().getDifficulty().getId() << 2));
                        this.playSound(SoundEvents.SKELETON_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
                        this.level().addFreshEntity((Entity)abstractarrow);
                    }
                    ++this.rangedAttackCounter;
                    break;
                }
                case 0: {
                    if (this.rangedAttackCounter % 15 == 0) {
                        PardimalArrow abstractarrow = new PardimalArrow(this.level(), (LivingEntity)this, new ItemStack((ItemLike)ItemRegistry.pardimal_arrow.get()), new ItemStack((ItemLike)ItemRegistry.pardimal_bow.get()));
                        abstractarrow.powerMultiplier = 1.2f;
                        double d0 = target.getX() - this.getX();
                        double d1 = target.getY(0.3333333333333333) - abstractarrow.getY();
                        double d2 = target.getZ() - this.getZ();
                        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
                        abstractarrow.shoot(d0, d1 + d3 * 0.2, d2, 1.6f, 14.0f - (float)(this.level().getDifficulty().getId() << 2));
                        this.playSound(SoundEvents.SKELETON_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
                        this.level().addFreshEntity((Entity)abstractarrow);
                    }
                    ++this.rangedAttackCounter;
                    break;
                }
            }
        }
    }

    public int getMaxSpawnClusterSize() {
        return 3;
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return super.getAmbientSound();
    }

    private QuadroAbility getRandomAbility() {
        return switch (this.random.nextInt(4)) {
            case 0 -> QuadroAbility.RANGED_SLOW;
            case 1 -> QuadroAbility.RANGED_FAST;
            case 2 -> QuadroAbility.MELEE_SLOW;
            case 3 -> QuadroAbility.MELEE_FAST;
            default -> null;
        };
    }

    static enum QuadroAbility {
        RANGED_SLOW,
        RANGED_FAST,
        MELEE_SLOW,
        MELEE_FAST;

    }
}

