/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.boss;

import divinerpg.entities.base.EntityDivineBoss;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.SoundRegistry;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class EntityHiveQueen
extends EntityDivineBoss {
    private int spawnTick = 80;

    public EntityHiveQueen(EntityType<? extends EntityHiveQueen> type, Level worldIn) {
        super((EntityType<? extends EntityDivineBoss>)type, worldIn);
    }

    public void tick() {
        super.tick();
        if (this.getHealth() > 0.0f) {
            if (this.spawnTick % 40 == 0 && !this.level().isClientSide && this.level().getNearestPlayer((Entity)this, 20.0) != null) {
                if (this.random.nextBoolean()) {
                    ((EntityType)EntityRegistry.HOVER_STINGER.get()).spawn((ServerLevel)this.level(), ItemStack.EMPTY, null, this.blockPosition(), MobSpawnType.MOB_SUMMONED, true, false);
                    this.level().addParticle((ParticleOptions)DustParticleOptions.REDSTONE, this.xo, this.yo, this.zo, this.random.nextGaussian() * 2.0 - 1.0, this.random.nextGaussian() * 2.0 - 1.0, this.random.nextGaussian() * 2.0 - 1.0);
                } else {
                    ((EntityType)EntityRegistry.HIVE_SOLDIER.get()).spawn((ServerLevel)this.level(), ItemStack.EMPTY, null, this.blockPosition(), MobSpawnType.MOB_SUMMONED, true, false);
                    this.level().addParticle((ParticleOptions)DustParticleOptions.REDSTONE, this.xo, this.yo, this.zo, this.random.nextGaussian() * 2.0 - 1.0, this.random.nextGaussian() * 2.0 - 1.0, this.random.nextGaussian() * 2.0 - 1.0);
                }
                this.spawnTick = 80;
            }
            --this.spawnTick;
        }
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.HIVE_QUEEN.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SoundRegistry.HIVE_QUEEN_HURT.get();
    }
}

