/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.boss;

import divinerpg.entities.base.EntityDivineFlyingMonster;
import divinerpg.entities.base.EntityDivineMonster;
import divinerpg.entities.projectile.DivineThrowableProjectile;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.SoundRegistry;
import divinerpg.util.WeightedRandom;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import org.jetbrains.annotations.Nullable;

public class EntityExperiencedCori
extends EntityDivineFlyingMonster
implements RangedAttackMob {
    private final ServerBossEvent bossEvent = new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.BLUE, BossEvent.BossBarOverlay.PROGRESS);
    private final WeightedRandom<EntityType<? extends EntityDivineMonster>> coriTypePool = new WeightedRandom();

    public EntityExperiencedCori(EntityType<? extends EntityExperiencedCori> type, Level worldIn) {
        super((EntityType<? extends EntityDivineFlyingMonster>)type, worldIn);
        this.xpReward = 50;
        this.coriTypePool.addItem((EntityType<? extends EntityDivineMonster>)((EntityType)EntityRegistry.WEAK_CORI.get()), 4);
        this.coriTypePool.addItem((EntityType<? extends EntityDivineMonster>)((EntityType)EntityRegistry.ADVANCED_CORI.get()), 1);
    }

    public Component getDisplayName() {
        return PlayerTeam.formatNameForTeam((Team)this.getTeam(), (Component)this.getName()).withStyle(s -> s.withHoverEvent(this.createHoverEvent()).withInsertion(this.getStringUUID()).withBold(Boolean.valueOf(true)));
    }

    public void performRangedAttack(LivingEntity entity, float range) {
        if (this.isAlive() && this.getTarget() != null && !this.level().isClientSide) {
            double tx = this.getTarget().getX() - this.getX();
            double ty = this.getTarget().getEyeY() - this.getEyeY();
            double tz = this.getTarget().getZ() - this.getZ();
            DivineThrowableProjectile e = (DivineThrowableProjectile)((EntityType)EntityRegistry.CORI_SHOT.get()).create(this.level());
            e.setPos(this.getEyePosition());
            e.setOwner((Entity)this);
            e.baseDamage = 80.0f;
            double horizontalDistance = Math.sqrt(tx * tx + tz * tz);
            e.shoot(tx, ty, tz, 1.6f, 0.0f);
            e.setDeltaMovement(tx / horizontalDistance * (double)1.6f, ty / horizontalDistance * (double)1.6f, tz / horizontalDistance * (double)1.6f);
            this.level().addFreshEntity((Entity)e);
        }
    }

    public void setCustomName(@Nullable Component name) {
        super.setCustomName(name);
        this.bossEvent.setName(this.getDisplayName());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (this.hasCustomName()) {
            this.bossEvent.setName(this.getDisplayName());
        }
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        this.bossEvent.addPlayer(player);
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.bossEvent.removePlayer(player);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
        this.goalSelector.addGoal(2, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 40, 64.0f));
    }

    public int getMaxSpawnClusterSize() {
        return 1;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.CORI_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SoundRegistry.CORI_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.CORI_HURT.get();
    }

    public boolean removeWhenFarAway(double dist) {
        return false;
    }

    @Override
    public void customServerAiStep() {
        super.customServerAiStep();
        this.bossEvent.setProgress(this.getHealth() / this.getMaxHealth());
        if (this.isAlive() && this.ambientSoundTime % (20 * (10 + this.random.nextInt(10))) == 0) {
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(this.getX() + (double)this.random.nextInt(8), this.getY(), this.getZ() + (double)this.random.nextInt(8));
            EntityType<? extends EntityDivineMonster> selectedCoriType = this.coriTypePool.selectRandomItem(new Random());
            if (selectedCoriType != null) {
                selectedCoriType.spawn((ServerLevel)this.level(), ItemStack.EMPTY, null, (BlockPos)pos, MobSpawnType.MOB_SUMMONED, true, false);
            }
        }
    }
}

