/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.base;

import divinerpg.attachments.Reputation;
import divinerpg.registries.AttachmentRegistry;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.MobEffectRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;

public interface FactionEntity {
    public Faction getFaction();

    default public void modifyReputationOnHurt(DamageSource source, float f) {
        Entity entity;
        if (source.getDirectEntity() != null && (entity = source.getDirectEntity()) instanceof Player) {
            Player player = (Player)entity;
            this.getFaction().reputation.modify((Entity)player, -1);
        } else if (source.getEntity() != null && (entity = source.getEntity()) instanceof Player) {
            Player player = (Player)entity;
            this.getFaction().reputation.modify((Entity)player, -1);
        }
    }

    default public void modifyReputationOnDeath(DamageSource source) {
        block3: {
            Object object;
            block2: {
                if (source.getDirectEntity() == null || !((object = source.getDirectEntity()) instanceof Player)) break block2;
                Player player = (Player)object;
                this.getFaction().reputation.modify((Entity)player, -10);
                for (Faction opposer : this.getFaction().enemies) {
                    opposer.reputation.modify((Entity)player, 2);
                }
                break block3;
            }
            if (source.getEntity() == null || !((object = source.getEntity()) instanceof Player)) break block3;
            Player player = (Player)object;
            this.getFaction().reputation.modify((Entity)player, -10);
            for (Faction opposer : this.getFaction().enemies) {
                opposer.reputation.modify((Entity)player, 2);
            }
        }
    }

    public static class Faction {
        public static final Faction GROGLIN = new Faction(true, 0, AttachmentRegistry.GROGLIN_REPUTATION){

            @Override
            public boolean isAggressiveTowards(LivingEntity entity) {
                return entity.hasEffect(MobEffectRegistry.GROGLIN_BOUNTY) || super.isAggressiveTowards(entity);
            }
        };
        public static final Faction GRUZZORLUG = new Faction(true, 0, AttachmentRegistry.GRUZZORLUG_REPUTATION){

            @Override
            public boolean isAggressiveTowards(LivingEntity entity) {
                return entity.hasEffect(MobEffectRegistry.GRUZZORLUG_TARGET) || super.isAggressiveTowards(entity);
            }
        };
        public static final Faction ICEIKA_MERCHANT = new Faction(false, 20, AttachmentRegistry.ICEIKA_MERCHANT_REPUTATION).addEnemy(GROGLIN).addEnemy(GRUZZORLUG);
        public final ArrayList<Faction> enemies = new ArrayList();
        public final ArrayList<Faction> allies = new ArrayList();
        public final ArrayList<EntityType<?>> nonFactionEnemies;
        public final ArrayList<EntityType<?>> nonFactionAllies = new ArrayList();
        public final Reputation reputation;
        public final boolean isAutoAggressive;
        public final int startingReputation;

        public static LivingEntity getNearestEnemy(LivingEntity from, AABB searchArea, TargetingConditions conditions) {
            List enemies = from.level().getEntities((Entity)from, searchArea, entity -> {
                if (entity instanceof LivingEntity) {
                    LivingEntity ent = (LivingEntity)entity;
                    if (from instanceof FactionEntity) {
                        FactionEntity fac = (FactionEntity)from;
                        if (fac.getFaction().isAggressiveTowards(ent)) return true;
                    }
                }
                if (!(entity instanceof FactionEntity)) return false;
                FactionEntity fact = (FactionEntity)entity;
                if (!fact.getFaction().isAggressiveTowards(from)) return false;
                return true;
            });
            double closest = -1.0;
            LivingEntity nearestEnemy = null;
            for (Entity enemy : enemies) {
                if (!conditions.test(from, (LivingEntity)enemy)) continue;
                double distance = enemy.distanceToSqr((Entity)from);
                if (closest != -1.0 && !(distance < closest)) continue;
                closest = distance;
                nearestEnemy = (LivingEntity)enemy;
            }
            return nearestEnemy;
        }

        public static boolean hasNearbyTarget(@Nullable Entity from, AABB searchArea, Faction faction) {
            return !from.level().getEntities(from, searchArea, entity -> {
                Player player;
                LivingEntity ent;
                return entity instanceof LivingEntity && faction.isAggressiveTowards(ent = (LivingEntity)entity) && (!(entity instanceof Player) || !(player = (Player)entity).isSpectator());
            }).isEmpty();
        }

        public Faction(boolean isAutoAggressive, int startingReputation, Reputation reputation) {
            this.isAutoAggressive = isAutoAggressive;
            this.startingReputation = startingReputation;
            this.nonFactionEnemies = isAutoAggressive ? null : new ArrayList();
            this.reputation = reputation;
        }

        public Faction addEnemy(Faction faction) {
            this.enemies.add(faction);
            this.allies.remove(faction);
            return this;
        }

        public Faction addEnemy(LivingEntity entity) {
            if (!this.isAutoAggressive) {
                this.nonFactionEnemies.add(entity.getType());
            }
            this.nonFactionAllies.remove(entity.getType());
            return this;
        }

        public Faction addAlly(Faction faction) {
            this.allies.add(faction);
            this.enemies.remove(faction);
            return this;
        }

        public Faction addAlly(LivingEntity entity) {
            EntityType t = entity.getType();
            this.nonFactionAllies.add(t);
            if (!this.isAutoAggressive) {
                this.nonFactionEnemies.remove(t);
            }
            return this;
        }

        public boolean isAlly(LivingEntity entity) {
            FactionEntity e;
            EntityType type = entity.getType();
            return entity instanceof FactionEntity && ((e = (FactionEntity)entity).getFaction().equals(this) || this.allies.contains(e.getFaction())) || this.nonFactionAllies.contains(type);
        }

        public boolean isAggressiveTowards(Faction faction) {
            return faction != this && !this.allies.contains(faction) && (this.isAutoAggressive || this.enemies.contains(faction));
        }

        public boolean isAggressiveTowards(LivingEntity entity) {
            Player player;
            EntityType type = entity.getType();
            if (this.nonFactionAllies.contains(type)) {
                return false;
            }
            if (!this.isAutoAggressive && this.nonFactionEnemies.contains(type)) {
                return true;
            }
            if (entity instanceof Player && !(player = (Player)entity).isCreative() && !player.isSpectator()) {
                return this.hates((LivingEntity)player);
            }
            if (entity instanceof FactionEntity) {
                FactionEntity fac = (FactionEntity)entity;
                return this.isAggressiveTowards(fac.getFaction());
            }
            return this.isAutoAggressive;
        }

        public int getReputation(LivingEntity e) {
            if (e.level().isClientSide() && !this.reputation.has((Entity)e)) {
                this.reputation.requestAttachment((Entity)e, null);
            }
            return (Integer)this.reputation.get((Entity)e);
        }

        public boolean hates(LivingEntity entity) {
            return this.getReputation(entity) < (this.isAutoAggressive ? 25 : -10);
        }

        public boolean likes(LivingEntity entity) {
            return this.getReputation(entity) > 24;
        }

        static {
            ArrayList<EntityType> iceikaNature = new ArrayList<EntityType>();
            iceikaNature.add(EntityType.COD);
            iceikaNature.add(EntityType.SALMON);
            iceikaNature.add(EntityType.TROPICAL_FISH);
            iceikaNature.add(EntityType.POLAR_BEAR);
            iceikaNature.add((EntityType)EntityRegistry.WHALE.get());
            iceikaNature.add((EntityType)EntityRegistry.LIOPLEURODON.get());
            iceikaNature.add((EntityType)EntityRegistry.AEQUOREA.get());
            iceikaNature.add((EntityType)EntityRegistry.ROBBIN.get());
            iceikaNature.add((EntityType)EntityRegistry.WOLPERTINGER.get());
            iceikaNature.add((EntityType)EntityRegistry.PALE_ARCHER.get());
            iceikaNature.add((EntityType)EntityRegistry.FROZEN_FLESH.get());
            iceikaNature.add((EntityType)EntityRegistry.ROLLUM.get());
            iceikaNature.add((EntityType)EntityRegistry.ALICANTO.get());
            iceikaNature.add((EntityType)EntityRegistry.SENG.get());
            iceikaNature.add((EntityType)EntityRegistry.HASTREUS.get());
            iceikaNature.add((EntityType)EntityRegistry.GLACIDE.get());
            iceikaNature.add((EntityType)EntityRegistry.FRACTITE.get());
            Faction.GRUZZORLUG.nonFactionAllies.addAll(iceikaNature);
            GRUZZORLUG.addEnemy(GROGLIN).addEnemy(ICEIKA_MERCHANT);
            iceikaNature.remove(EntityRegistry.SENG.get());
            iceikaNature.remove(EntityType.COD);
            iceikaNature.add((EntityType)EntityRegistry.SABEAR.get());
            Faction.GROGLIN.nonFactionAllies.addAll(iceikaNature);
            GROGLIN.addEnemy(GRUZZORLUG).addEnemy(ICEIKA_MERCHANT);
        }
    }
}

