/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.base;

import divinerpg.block_entities.block.InserterBlockEntity;
import divinerpg.registries.BlockRegistry;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.ItemRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.Hopper;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.IItemHandler;

public class EntityInserterMinecart
extends AbstractMinecart
implements Hopper {
    protected ItemStack stack = ItemStack.EMPTY;
    protected boolean enabled = true;

    public EntityInserterMinecart(EntityType<? extends EntityInserterMinecart> entityType, Level level) {
        super(entityType, level);
    }

    public EntityInserterMinecart(Level level, double x, double y, double z) {
        super((EntityType)EntityRegistry.INSERTER_MINECART.get(), level, x, y, z);
    }

    public AbstractMinecart.Type getMinecartType() {
        return AbstractMinecart.Type.HOPPER;
    }

    public ItemStack getPickResult() {
        return new ItemStack((ItemLike)this.getDropItem());
    }

    protected Item getDropItem() {
        return (Item)ItemRegistry.inserter_minecart.get();
    }

    public double getLevelX() {
        return this.getX();
    }

    public double getLevelY() {
        return this.getY() + 0.5;
    }

    public double getLevelZ() {
        return this.getZ();
    }

    public boolean isGridAligned() {
        return false;
    }

    public int getContainerSize() {
        return 1;
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    public ItemStack getItem() {
        return this.stack;
    }

    public ItemStack getItem(int i) {
        return this.stack;
    }

    public ItemStack removeItem(int i, int amount) {
        return this.removeItem(amount);
    }

    protected ItemStack removeItem(int amount) {
        if (amount <= 0) {
            return ItemStack.EMPTY;
        }
        this.setChanged();
        int c = this.stack.getCount();
        if (amount > c) {
            ItemStack s = this.stack;
            this.stack = ItemStack.EMPTY;
            return s;
        }
        ItemStack s = this.stack.copyWithCount(amount);
        this.stack.setCount(this.stack.getCount() - amount);
        return s;
    }

    public ItemStack removeItemNoUpdate(int i) {
        ItemStack s = this.stack;
        this.stack = ItemStack.EMPTY;
        return s;
    }

    protected void setItem(ItemStack s) {
        this.stack = s == null ? ItemStack.EMPTY : s;
    }

    public void setItem(int i, ItemStack s) {
        this.setItem(s);
    }

    public void setChanged() {
    }

    public boolean stillValid(Player player) {
        return !player.isSpectator();
    }

    public void clearContent() {
        this.stack = ItemStack.EMPTY;
    }

    public BlockState getDefaultDisplayBlockState() {
        return (BlockState)((Block)BlockRegistry.inserter.get()).defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN);
    }

    public int getDefaultDisplayOffset() {
        return 1;
    }

    public void activateMinecart(int x, int y, int z, boolean receivingPower) {
        this.enabled = !receivingPower;
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Enabled", this.enabled);
        if (this.stack != null && !this.stack.isEmpty()) {
            compound.put("item", this.getItem().save((HolderLookup.Provider)this.registryAccess()));
        }
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        boolean bl = this.enabled = !compound.contains("Enabled") || compound.getBoolean("Enabled");
        if (compound.contains("item")) {
            this.stack = ItemStack.parseOptional((HolderLookup.Provider)this.registryAccess(), (CompoundTag)compound.getCompound("item"));
        }
    }

    public void destroy(DamageSource source) {
        super.destroy(source);
        if (this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            Entity entity;
            Containers.dropContents((Level)this.level(), (Entity)this, (Container)this);
            if (!this.level().isClientSide && (entity = source.getDirectEntity()) != null && entity.getType() == EntityType.PLAYER) {
                PiglinAi.angerNearbyPiglins((Player)((Player)entity), (boolean)true);
            }
        }
    }

    public void remove(Entity.RemovalReason reason) {
        if (!this.level().isClientSide && reason.shouldDestroy()) {
            Containers.dropContents((Level)this.level(), (Entity)this, (Container)this);
        }
        super.remove(reason);
    }

    protected void applyNaturalSlowdown() {
        float f = 0.98f;
        int i = 15 - AbstractContainerMenu.getRedstoneSignalFromContainer((Container)this);
        f += (float)i * 0.001f;
        if (this.isInWater()) {
            f *= 0.95f;
        }
        this.setDeltaMovement(this.getDeltaMovement().multiply((double)f, 0.0, (double)f));
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide && this.isAlive() && this.enabled && !this.isEmpty()) {
            if (this.insertHook()) {
                return;
            }
            Container container = HopperBlockEntity.getContainerAt((Level)this.level(), (BlockPos)this.blockPosition().below());
            if (container == null) {
                return;
            }
            if (InserterBlockEntity.isFullContainer(container, Direction.UP)) {
                return;
            }
            ItemStack itemstack = this.getItem();
            if (!itemstack.isEmpty()) {
                int j = itemstack.getCount();
                ItemStack itemstack1 = HopperBlockEntity.addItem((Container)this, (Container)container, (ItemStack)this.removeItem(1), (Direction)Direction.UP);
                if (itemstack1.isEmpty()) {
                    container.setChanged();
                    return;
                }
                itemstack.setCount(j);
                if (j == 1) {
                    this.setItem(itemstack);
                }
            }
        }
    }

    boolean insertHook() {
        return InserterBlockEntity.getAttachedItemHandler(this.level(), this.blockPosition(), Direction.DOWN).map(destinationResult -> {
            IItemHandler itemHandler = (IItemHandler)destinationResult.getKey();
            if (InserterBlockEntity.isFull(itemHandler)) {
                return false;
            }
            if (!this.getItem().isEmpty()) {
                ItemStack originalSlotContents = this.getItem().copy();
                ItemStack insertStack = this.removeItem(1);
                ItemStack remainder = InserterBlockEntity.putStackInInventoryAllSlots(itemHandler, insertStack);
                if (remainder.isEmpty()) {
                    return true;
                }
                this.setItem(originalSlotContents);
            }
            return false;
        }).orElse(false);
    }
}

