/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.base;

import java.util.ArrayList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public abstract class EntityGifterNPC
extends PathfinderMob {
    public EntityGifterNPC(EntityType<? extends PathfinderMob> type, Level worldIn) {
        super(type, worldIn);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public boolean checkSpawnRules(LevelAccessor p_21686_, MobSpawnType p_21687_) {
        return true;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (this.isAlive()) {
            if (!this.level().isClientSide()) {
                player.getInventory().add(this.getGift());
                this.sendRandomChatMessage(player);
                this.remove(Entity.RemovalReason.DISCARDED);
            }
            return InteractionResult.PASS;
        }
        return super.mobInteract(player, hand);
    }

    protected void sendRandomChatMessage(Player player) {
        ArrayList<String> messages = this.getMessages();
        String name = Component.translatable((String)this.getTranslationName()).getString();
        String messageToTranslate = Component.translatable((String)messages.get(this.random.nextInt(messages.size()))).getString();
        MutableComponent message = Component.translatable((String)(name + ": " + messageToTranslate));
        player.displayClientMessage((Component)message, true);
    }

    protected abstract ItemStack getGift();

    protected abstract ArrayList<String> getMessages();

    protected abstract String getTranslationName();
}

