/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.base;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FollowBoatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;

public class EntityDivineWaterMob
extends WaterAnimal
implements Enemy {
    public EntityDivineWaterMob(EntityType<? extends EntityDivineWaterMob> type, Level worldIn) {
        super(type, worldIn);
    }

    protected int getBaseExperienceReward() {
        return 5;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.goalSelector.addGoal(2, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 10));
        this.goalSelector.addGoal(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 32.0f));
        this.goalSelector.addGoal(3, (Goal)new FollowBoatGoal((PathfinderMob)this));
        this.goalSelector.addGoal(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, Guardian.class, 8.0f, 1.0, 1.0));
        this.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Guardian.class}).setAlertOthers(new Class[0]));
    }

    public boolean checkSpawnObstruction(LevelReader worldIn) {
        return worldIn.containsAnyLiquid(this.getBoundingBox()) && worldIn.noCollision((Entity)this);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance instance, MobSpawnType type, @Nullable SpawnGroupData data) {
        this.setAirSupply(this.getMaxAirSupply());
        this.setXRot(0.0f);
        return data;
    }

    protected void handleAirSupply(int p_28326_) {
    }

    protected PathNavigation createNavigation(Level level) {
        return new WaterBoundPathNavigation((Mob)this, level);
    }

    public int getMaxHeadXRot() {
        return 1;
    }

    public int getMaxHeadYRot() {
        return 1;
    }

    public void tick() {
        super.tick();
        if (this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().add((double)((this.random.nextFloat() * 2.0f - 1.0f) * 0.2f), 0.5, (double)((this.random.nextFloat() * 2.0f - 1.0f) * 0.2f)));
            this.setYRot(this.random.nextFloat() * 360.0f);
            this.setOnGround(false);
            this.hasImpulse = true;
        }
    }

    protected boolean closeToNextPos() {
        BlockPos blockpos = this.getNavigation().getTargetPos();
        return blockpos != null ? blockpos.closerToCenterThan((Position)this.position(), 12.0) : false;
    }

    public void travel(Vec3 vec) {
        if (this.isEffectiveAi() && this.isInWater()) {
            this.moveRelative(this.getSpeed(), vec);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
            if (this.getTarget() == null) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.005, 0.0));
            }
        } else {
            super.travel(vec);
        }
    }
}

