/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.arcana;

import divinerpg.entities.base.EntityDivineTameable;
import divinerpg.registries.SoundRegistry;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityWraith
extends EntityDivineTameable {
    public EntityWraith(EntityType<? extends TamableAnimal> type, Level worldIn, Player player) {
        this(type, worldIn);
        this.tame(player);
    }

    public EntityWraith(EntityType<? extends TamableAnimal> type, Level worldIn) {
        super(type, worldIn, 1.0f);
        this.moveControl = new MoveHelperController(this);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(5, (Goal)new RandomFlyGoal(this));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 64.0f));
        this.goalSelector.addGoal(6, (Goal)new LookAroundGoal(this));
    }

    protected float getSoundVolume() {
        return 0.1f;
    }

    public float getVoicePitch() {
        return super.getVoicePitch() * 0.95f;
    }

    @Nullable
    public SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.WRAITH.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)SoundRegistry.WRAITH_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.WRAITH_HURT.get();
    }

    static class MoveHelperController
    extends MoveControl {
        private final EntityWraith parentEntity;
        private int courseChangeCooldown;

        public MoveHelperController(EntityWraith ent) {
            super((Mob)ent);
            this.parentEntity = ent;
        }

        public void tick() {
            if (this.operation == MoveControl.Operation.MOVE_TO) {
                this.mob.setNoGravity(true);
                double d0 = this.wantedX - this.mob.getX();
                double d1 = this.wantedY - this.mob.getY();
                double d2 = this.wantedZ - this.mob.getZ();
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if (d3 < 2.500000277905201E-7) {
                    this.mob.setYya(0.0f);
                    this.mob.setZza(0.0f);
                    return;
                }
                float f = (float)(Mth.atan2((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.mob.yHeadRot = this.rotlerp(this.mob.getYRot(), f, 90.0f);
                float f1 = this.mob.onGround() ? (float)(this.speedModifier * this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED)) : (float)(this.speedModifier * this.mob.getAttributeValue(Attributes.FLYING_SPEED));
                this.mob.setSpeed(f1);
                double d4 = Mth.sqrt((float)((float)(d0 * d0 + d2 * d2)));
                float f2 = (float)(-(Mth.atan2((double)d1, (double)d4) * 57.2957763671875));
                this.mob.xRotO = this.rotlerp(this.mob.getXRot(), f2, 20.0f);
                this.mob.setYya(d1 > 0.0 ? f1 : -f1);
                if (this.courseChangeCooldown-- <= 0) {
                    this.courseChangeCooldown += this.parentEntity.getRandom().nextInt(5) + 2;
                    Vec3 vector3d = new Vec3(this.wantedX - this.parentEntity.getX(), this.wantedY - this.parentEntity.getY(), this.wantedZ - this.parentEntity.getZ());
                    double d5 = vector3d.length();
                    if (this.canReach(vector3d = vector3d.normalize(), Mth.ceil((double)d5))) {
                        this.parentEntity.setDeltaMovement(this.parentEntity.getDeltaMovement().add(vector3d.scale(0.1)));
                    } else {
                        this.operation = MoveControl.Operation.WAIT;
                    }
                }
            }
        }

        private boolean canReach(Vec3 p_220673_1_, int p_220673_2_) {
            AABB axisalignedbb = this.parentEntity.getBoundingBox();
            for (int i = 1; i < p_220673_2_; ++i) {
                axisalignedbb = axisalignedbb.move(p_220673_1_);
                if (this.parentEntity.level().noCollision((Entity)this.parentEntity, axisalignedbb)) continue;
                return false;
            }
            return true;
        }
    }

    static class RandomFlyGoal
    extends Goal {
        private final EntityWraith parentEntity;

        public RandomFlyGoal(EntityWraith ent) {
            this.parentEntity = ent;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            double d2;
            double d1;
            if (this.parentEntity.getTarget() != null) {
                return false;
            }
            MoveControl movementcontroller = this.parentEntity.getMoveControl();
            if (!movementcontroller.hasWanted()) {
                return true;
            }
            double d0 = movementcontroller.getWantedX() - this.parentEntity.getX();
            double d3 = d0 * d0 + (d1 = movementcontroller.getWantedY() - this.parentEntity.getY()) * d1 + (d2 = movementcontroller.getWantedZ() - this.parentEntity.getZ()) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean canContinueToUse() {
            return false;
        }

        public void start() {
            RandomSource random = this.parentEntity.getRandom();
            double d0 = this.parentEntity.getX() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.parentEntity.getY() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d2 = this.parentEntity.getZ() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.parentEntity.getMoveControl().setWantedPosition(d0, d1, d2, 1.0);
        }
    }

    static class LookAroundGoal
    extends Goal {
        private final EntityWraith parentEntity;

        public LookAroundGoal(EntityWraith ent) {
            this.parentEntity = ent;
            this.setFlags(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return true;
        }

        public void tick() {
            if (this.parentEntity.getTarget() == null) {
                Vec3 vector3d = this.parentEntity.getDeltaMovement();
                this.parentEntity.lerpXRot = -((float)Mth.atan2((double)vector3d.x, (double)vector3d.z)) * 57.295776f;
                this.parentEntity.xRotO = this.parentEntity.getXRot();
            } else {
                LivingEntity livingentity = this.parentEntity.getTarget();
                if (livingentity.distanceToSqr((Entity)this.parentEntity) < 4096.0) {
                    double d1 = livingentity.getX() - this.parentEntity.getX();
                    double d2 = livingentity.getZ() - this.parentEntity.getZ();
                    this.parentEntity.lerpXRot = -((float)Mth.atan2((double)d1, (double)d2)) * 57.295776f;
                    this.parentEntity.xRotO = this.parentEntity.getXRot();
                }
            }
        }
    }
}

