/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.arcana;

import divinerpg.entities.base.EntityDivineTameable;
import divinerpg.registries.AttachmentRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class EntityParatiku
extends EntityDivineTameable {
    private static final TargetingConditions RESTING_TARGETING = TargetingConditions.forCombat().range(4.0);

    public EntityParatiku(EntityType<? extends TamableAnimal> type, Level level) {
        super(type, level, 1.0f);
        if (!level.isClientSide) {
            this.setIsParatikuHanging(true);
        }
    }

    public boolean isPushable() {
        return false;
    }

    protected void doPush(Entity ent) {
    }

    protected void pushEntities() {
    }

    protected void checkFallDamage(double d, boolean b, BlockState s, BlockPos p) {
    }

    public boolean isIgnoringBlockTriggers() {
        return true;
    }

    protected float getSoundVolume() {
        return 0.1f;
    }

    public float getVoicePitch() {
        return super.getVoicePitch() * 0.95f;
    }

    protected SoundEvent getAmbientSound() {
        return this.getIsParatikuHanging() && this.random.nextInt(4) != 0 ? null : SoundEvents.BAT_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.BAT_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.BAT_DEATH;
    }

    public boolean getIsParatikuHanging() {
        return (Boolean)AttachmentRegistry.HANGING.get((Entity)this);
    }

    public void setIsParatikuHanging(boolean isHanging) {
        AttachmentRegistry.HANGING.setSilent((Entity)this, isHanging);
    }

    public void tick() {
        super.tick();
        if (this.getIsParatikuHanging()) {
            this.setDeltaMovement(0.0, 0.0, 0.0);
            this.setPosRaw(this.getX(), (double)Mth.floor((double)this.getY()) + 1.0 - (double)this.getBbHeight(), this.getZ());
        } else {
            this.setDeltaMovement(this.getDeltaMovement().x, this.getDeltaMovement().y * (double)0.6f, this.getDeltaMovement().z);
        }
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        BlockPos blockpos = this.blockPosition();
        BlockPos blockpos1 = blockpos.above();
        if (this.getIsParatikuHanging()) {
            boolean flag = this.isSilent();
            if (this.level().getBlockState(blockpos1).isRedstoneConductor((BlockGetter)this.level(), blockpos)) {
                if (this.random.nextInt(200) == 0) {
                    this.yHeadRot = this.random.nextInt(360);
                }
                if (this.level().getNearestPlayer(RESTING_TARGETING, (LivingEntity)this) != null) {
                    this.setIsParatikuHanging(false);
                    if (!flag) {
                        this.level().levelEvent(null, 1025, blockpos, 0);
                    }
                }
            } else {
                this.setIsParatikuHanging(false);
                if (!flag) {
                    this.level().levelEvent(null, 1025, blockpos, 0);
                }
            }
        } else if (this.getTarget() != null) {
            this.getTarget().blockPosition();
            if (this.random.nextInt(30) == 0 || this.getTarget().blockPosition().closerToCenterThan((Position)this.position(), 2.0)) {
                this.moveTo(this.getX() + (double)this.random.nextInt(7) - (double)this.random.nextInt(7), this.getY() + (double)this.random.nextInt(6) - 2.0, this.getZ() + (double)this.random.nextInt(7) - (double)this.random.nextInt(7));
            }
            double d2 = (double)this.getTarget().blockPosition().getX() + 0.5 - this.getX();
            double d0 = (double)this.getTarget().blockPosition().getY() + 0.1 - this.getY();
            double d1 = (double)this.getTarget().blockPosition().getZ() + 0.5 - this.getZ();
            Vec3 vector3d = this.getDeltaMovement();
            Vec3 vector3d1 = vector3d.add((Math.signum(d2) * 0.5 - vector3d.x) * 0.1, (Math.signum(d0) * 0.7 - vector3d.y) * 0.1, (Math.signum(d1) * 0.5 - vector3d.z) * 0.1);
            this.setDeltaMovement(vector3d1);
            float f = (float)(Mth.atan2((double)vector3d1.z, (double)vector3d1.x) * 57.29577951308232) - 90.0f;
            float f1 = Mth.wrapDegrees((float)(f - this.getYRot()));
            this.zza = 0.5f;
            this.yHeadRot += f1;
            if (this.random.nextInt(100) == 0 && this.level().getBlockState(blockpos1).isRedstoneConductor((BlockGetter)this.level(), blockpos1)) {
                this.setIsParatikuHanging(true);
            }
        }
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        if (source.isCreativePlayer()) {
            return false;
        }
        if (!this.level().isClientSide() && this.getIsParatikuHanging()) {
            this.setIsParatikuHanging(false);
        }
        return super.hurt(source, amount);
    }
}

