/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.effect.dimension;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import divinerpg.registries.LevelRegistry;
import divinerpg.registries.MobEffectRegistry;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class TwilightSky
extends DimensionSpecialEffects {
    public static final ResourceLocation SUN_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"textures/particle/twilight_sun.png");
    public static final ResourceLocation POG_SUN_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"textures/particle/pog_sun.png");
    @Nullable
    private VertexBuffer skyBuffer;
    @Nullable
    private VertexBuffer starBuffer;

    public TwilightSky() {
        super(256.0f, true, DimensionSpecialEffects.SkyType.NORMAL, false, false);
        Tesselator tesselator = Tesselator.getInstance();
        RenderSystem.setShader(GameRenderer::getPositionShader);
        if (this.starBuffer != null) {
            this.starBuffer.close();
        }
        this.starBuffer = new VertexBuffer(VertexBuffer.Usage.DYNAMIC);
        MeshData bufferbuilder$renderedbuffer = TwilightSky.drawStars(tesselator);
        this.starBuffer.bind();
        this.starBuffer.upload(bufferbuilder$renderedbuffer);
        VertexBuffer.unbind();
        tesselator = Tesselator.getInstance();
        if (this.skyBuffer != null) {
            this.skyBuffer.close();
        }
        this.skyBuffer = new VertexBuffer(VertexBuffer.Usage.DYNAMIC);
        bufferbuilder$renderedbuffer = TwilightSky.buildSkyDisc(tesselator, 16.0f);
        this.skyBuffer.bind();
        this.skyBuffer.upload(bufferbuilder$renderedbuffer);
        VertexBuffer.unbind();
    }

    public Vec3 getBrightnessDependentFogColor(Vec3 color, float sunHeight) {
        return color.multiply((double)sunHeight * 0.94 + 0.06, (double)sunHeight * 0.94 + 0.06, (double)sunHeight * 0.91 + 0.09);
    }

    public boolean isFoggyAt(int i, int ii) {
        return false;
    }

    public boolean renderSky(ClientLevel level, int ticks, float partialTick, Matrix4f modelViewMatrix, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
        FogType fogtype;
        setupFog.run();
        if (!isFoggy && (fogtype = camera.getFluidInCamera()) != FogType.POWDER_SNOW && fogtype != FogType.LAVA && !TwilightSky.doesMobEffectBlockSky(camera)) {
            Vec3 vec3 = level.getSkyColor(camera.getPosition(), partialTick);
            float f = (float)vec3.x;
            float f1 = (float)vec3.y;
            float f2 = (float)vec3.z;
            FogRenderer.levelFogColor();
            BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
            RenderSystem.depthMask((boolean)false);
            RenderSystem.setShaderColor((float)f, (float)f1, (float)f2, (float)1.0f);
            ShaderInstance shaderinstance = RenderSystem.getShader();
            this.skyBuffer.bind();
            this.skyBuffer.drawWithShader(modelViewMatrix, projectionMatrix, shaderinstance);
            VertexBuffer.unbind();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            float[] afloat = level.effects().getSunriseColor(level.getTimeOfDay(partialTick), partialTick);
            if (afloat != null) {
                RenderSystem.setShader(GameRenderer::getPositionColorShader);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                modelViewMatrix.rotate((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
                float f3 = Mth.sin((float)level.getSunAngle(partialTick)) < 0.0f ? 180.0f : 0.0f;
                modelViewMatrix.rotate((Quaternionfc)Axis.ZP.rotationDegrees(f3));
                modelViewMatrix.rotate((Quaternionfc)Axis.ZP.rotationDegrees(90.0f));
                float f4 = afloat[0];
                float f5 = afloat[1];
                float f6 = afloat[2];
                bufferbuilder.addVertex(modelViewMatrix, 0.0f, 100.0f, 0.0f).setColor(f4, f5, f6, afloat[3]);
                for (int j = 0; j <= 16; ++j) {
                    float f7 = (float)((double)j * (Math.PI * 2) / 16.0);
                    float f8 = Mth.sin((float)f7);
                    float f9 = Mth.cos((float)f7);
                    bufferbuilder.addVertex(modelViewMatrix, f8 * 120.0f, f9 * 120.0f, -f9 * 40.0f * afloat[3]).setColor(afloat[0], afloat[1], afloat[2], 0.0f);
                }
                BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
                modelViewMatrix.rotate((Quaternionfc)Axis.ZP.rotationDegrees(-90.0f));
                modelViewMatrix.rotate((Quaternionfc)Axis.ZP.rotationDegrees(-f3));
                modelViewMatrix.rotate((Quaternionfc)Axis.XP.rotationDegrees(-90.0f));
            }
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            float f11 = 1.0f - level.getRainLevel(partialTick);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)f11);
            modelViewMatrix.rotate((Quaternionfc)Axis.YP.rotationDegrees(-90.0f));
            modelViewMatrix.rotate((Quaternionfc)Axis.XP.rotationDegrees(level.getTimeOfDay(partialTick) * 360.0f));
            float f12 = 30.0f;
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)(level.dimension() == LevelRegistry.MORTUM && camera.getPosition().y < 0.0 ? POG_SUN_LOCATION : SUN_LOCATION));
            BufferBuilder bufferbuilder1 = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            bufferbuilder1.addVertex(modelViewMatrix, -f12, 100.0f, -f12).setUv(0.0f, 0.0f);
            bufferbuilder1.addVertex(modelViewMatrix, f12, 100.0f, -f12).setUv(1.0f, 0.0f);
            bufferbuilder1.addVertex(modelViewMatrix, f12, 100.0f, f12).setUv(1.0f, 1.0f);
            bufferbuilder1.addVertex(modelViewMatrix, -f12, 100.0f, f12).setUv(0.0f, 1.0f);
            BufferUploader.drawWithShader((MeshData)bufferbuilder1.buildOrThrow());
            float f10 = level.getStarBrightness(partialTick) * f11 * 1.01f;
            if (f10 > 0.0f) {
                RenderSystem.setShaderColor((float)f10, (float)f10, (float)f10, (float)f10);
                FogRenderer.setupNoFog();
                this.starBuffer.bind();
                this.starBuffer.drawWithShader(modelViewMatrix, projectionMatrix, GameRenderer.getPositionShader());
                VertexBuffer.unbind();
                setupFog.run();
            }
            modelViewMatrix.rotate((Quaternionfc)Axis.XP.rotationDegrees(level.getTimeOfDay(partialTick) * -360.0f));
            modelViewMatrix.rotate((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
            if (level.dimension() == LevelRegistry.EDEN) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)0.9f, (float)1.0f);
            } else if (level.dimension() == LevelRegistry.WILDWOOD) {
                RenderSystem.setShaderColor((float)0.8f, (float)0.9f, (float)1.0f, (float)1.0f);
            } else if (level.dimension() == LevelRegistry.APALACHIA) {
                RenderSystem.setShaderColor((float)0.9f, (float)0.8f, (float)1.0f, (float)1.0f);
            } else if (level.dimension() == LevelRegistry.SKYTHERN) {
                RenderSystem.setShaderColor((float)0.9f, (float)0.9f, (float)1.0f, (float)1.0f);
            } else if (level.dimension() == LevelRegistry.MORTUM) {
                RenderSystem.setShaderColor((float)0.9f, (float)0.8f, (float)0.8f, (float)1.0f);
            } else {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.depthMask((boolean)true);
        }
        return true;
    }

    public static boolean doesMobEffectBlockSky(Camera camera) {
        Entity entity = camera.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity livingentity = (LivingEntity)entity;
        return livingentity.hasEffect(MobEffects.BLINDNESS) || livingentity.hasEffect(MobEffects.DARKNESS) || livingentity.hasEffect(MobEffectRegistry.HEAVY_AIR);
    }

    public static MeshData buildSkyDisc(Tesselator tesselator, float g) {
        float f = Math.signum(g) * 512.0f;
        RenderSystem.setShader(GameRenderer::getPositionShader);
        BufferBuilder builder = tesselator.begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION);
        builder.addVertex(0.0f, g, 0.0f);
        for (int i = -180; i <= 180; i += 45) {
            builder.addVertex((float)((double)f * Math.cos((double)i * (Math.PI / 180))), g, (float)(512.0 * Math.sin((double)i * (Math.PI / 180))));
        }
        return builder.build();
    }

    public static MeshData drawStars(Tesselator tesselator) {
        RandomSource randomsource = RandomSource.create((long)10842L);
        BufferBuilder builder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
        for (int i = 0; i < 1500; ++i) {
            double d0 = randomsource.nextFloat() * 2.0f - 1.0f;
            double d1 = randomsource.nextFloat() * 2.0f - 1.0f;
            double d2 = randomsource.nextFloat() * 2.0f - 1.0f;
            double d3 = 0.15f + randomsource.nextFloat() * 0.1f;
            double d4 = d0 * d0 + d1 * d1 + d2 * d2;
            if (!(d4 < 1.0) || !(d4 > 0.01)) continue;
            d4 = 1.0 / Math.sqrt(d4);
            double d5 = (d0 *= d4) * 100.0;
            double d6 = (d1 *= d4) * 100.0;
            double d7 = (d2 *= d4) * 100.0;
            double d8 = Math.atan2(d0, d2);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            double d11 = Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = randomsource.nextDouble() * Math.PI * 2.0;
            double d15 = Math.sin(d14);
            double d16 = Math.cos(d14);
            for (int j = 0; j < 4; ++j) {
                double d18 = (double)((j & 2) - 1) * d3;
                double d19 = (double)((j + 1 & 2) - 1) * d3;
                double d21 = d18 * d16 - d19 * d15;
                double d22 = d19 * d16 + d18 * d15;
                double d23 = d21 * d12 + 0.0 * d13;
                double d24 = 0.0 * d12 - d21 * d13;
                double d25 = d24 * d9 - d22 * d10;
                double d26 = d22 * d9 + d24 * d10;
                builder.addVertex((float)(d5 + d25), (float)(d6 + d23), (float)(d7 + d26));
            }
        }
        return builder.build();
    }
}

