/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.compat.jei.category;

import divinerpg.recipe.ArcaniumExtractorRecipe;
import divinerpg.registries.BlockRegistry;
import divinerpg.registries.ItemRegistry;
import divinerpg.registries.RecipeRegistry;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class ArcaniumExtractorCategory
implements IRecipeCategory<RecipeHolder<ArcaniumExtractorRecipe>> {
    public static final ResourceLocation ARCANIUM_EXTRACTOR = ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"textures/gui/jei/arcanium_extractor.png");
    public static final RecipeType<RecipeHolder<ArcaniumExtractorRecipe>> RECIPE_TYPE = RecipeType.createFromVanilla((net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)RecipeRegistry.Types.ARCANIUM_EXTRACTOR_RECIPE_TYPE.get()));
    private final IDrawable icon;
    private final IDrawable background;

    public ArcaniumExtractorCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(ARCANIUM_EXTRACTOR, 1, 1, 167, 78);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)BlockRegistry.arcaniumExtractor.toStack());
    }

    public RecipeType<RecipeHolder<ArcaniumExtractorRecipe>> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)((Block)BlockRegistry.arcaniumExtractor.get()).getDescriptionId());
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<ArcaniumExtractorRecipe> recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 51, 12).addIngredients((Ingredient)((ArcaniumExtractorRecipe)recipe.value()).getIngredients().getFirst());
        builder.addSlot(RecipeIngredientRole.CATALYST, 51, 48).addItemStack(ItemRegistry.collector.toStack());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 111, 30).addItemStack(((ArcaniumExtractorRecipe)recipe.value()).getResultItem(null));
    }

    public void draw(RecipeHolder<ArcaniumExtractorRecipe> recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics);
    }

    public int getWidth() {
        return this.background.getWidth();
    }

    public int getHeight() {
        return this.background.getHeight();
    }
}

