/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import divinerpg.client.menu.AltarOfCorruptionMenu;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.EnchantmentNames;
import net.minecraft.client.model.BookModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Holder;
import net.minecraft.core.IdMap;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AltarOfCorruptionScreen
extends AbstractContainerScreen<AltarOfCorruptionMenu> {
    private static final ResourceLocation ENCHANTING_TABLE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"textures/gui/altar_of_corruption.png");
    private static final ResourceLocation ENCHANTING_BOOK_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"textures/model/altar_book.png");
    private final RandomSource random = RandomSource.create();
    private BookModel bookModel;
    public int time;
    public float flip;
    public float oFlip;
    public float flipT;
    public float flipA;
    public float open;
    public float oOpen;
    private ItemStack last = ItemStack.EMPTY;

    public AltarOfCorruptionScreen(AltarOfCorruptionMenu p_98754_, Inventory p_98755_, Component p_98756_) {
        super((AbstractContainerMenu)p_98754_, p_98755_, p_98756_);
    }

    protected void init() {
        super.init();
        this.bookModel = new BookModel(this.minecraft.getEntityModels().bakeLayer(ModelLayers.BOOK));
    }

    public void containerTick() {
        super.containerTick();
        this.tickBook();
    }

    public boolean mouseClicked(double p_98758_, double p_98759_, int p_98760_) {
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        for (int k = 0; k < 3; ++k) {
            double d0 = p_98758_ - (double)(i + 60);
            double d1 = p_98759_ - (double)(j + 14 + 19 * k);
            if (!(d0 >= 0.0) || !(d1 >= 0.0) || !(d0 < 108.0) || !(d1 < 19.0) || !((AltarOfCorruptionMenu)this.menu).clickMenuButton((Player)this.minecraft.player, k)) continue;
            this.minecraft.gameMode.handleInventoryButtonClick(((AltarOfCorruptionMenu)this.menu).containerId, k);
            return true;
        }
        return super.mouseClicked(p_98758_, p_98759_, p_98760_);
    }

    protected void renderBg(GuiGraphics p_282430_, float p_282530_, int p_281621_, int p_283333_) {
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        p_282430_.blit(ENCHANTING_TABLE_LOCATION, i, j, 0, 0, this.imageWidth, this.imageHeight);
        this.renderBook(p_282430_, i, j, p_282530_);
        EnchantmentNames.getInstance().initSeed((long)((AltarOfCorruptionMenu)this.menu).getEnchantmentSeed());
        int k = ((AltarOfCorruptionMenu)this.menu).getGoldCount();
        for (int l = 0; l < 3; ++l) {
            int i1 = i + 60;
            int j1 = i1 + 20;
            int k1 = ((AltarOfCorruptionMenu)this.menu).costs[l];
            if (k1 == 0) {
                p_282430_.blit(ENCHANTING_TABLE_LOCATION, i1, j + 14 + 19 * l, 0, 185, 108, 19);
                continue;
            }
            String s = "" + k1;
            int l1 = 86 - this.font.width(s);
            FormattedText formattedtext = EnchantmentNames.getInstance().getRandomName(this.font, l1);
            int i2 = 6839882;
            if ((k < l + 1 || this.minecraft.player.experienceLevel < k1) && !this.minecraft.player.getAbilities().instabuild || ((AltarOfCorruptionMenu)this.menu).enchantClue[l] == -1) {
                p_282430_.blit(ENCHANTING_TABLE_LOCATION, i1, j + 14 + 19 * l, 0, 185, 108, 19);
                p_282430_.blit(ENCHANTING_TABLE_LOCATION, i1 + 1, j + 15 + 19 * l, 16 * l, 239, 16, 16);
                p_282430_.drawWordWrap(this.font, formattedtext, j1, j + 16 + 19 * l, l1, (i2 & 0xFEFEFE) >> 1);
                i2 = 4226832;
            } else {
                int j2 = p_281621_ - (i + 60);
                int k2 = p_283333_ - (j + 14 + 19 * l);
                if (j2 >= 0 && k2 >= 0 && j2 < 108 && k2 < 19) {
                    p_282430_.blit(ENCHANTING_TABLE_LOCATION, i1, j + 14 + 19 * l, 0, 204, 108, 19);
                    i2 = 0xFFFF80;
                } else {
                    p_282430_.blit(ENCHANTING_TABLE_LOCATION, i1, j + 14 + 19 * l, 0, 166, 108, 19);
                }
                p_282430_.blit(ENCHANTING_TABLE_LOCATION, i1 + 1, j + 15 + 19 * l, 16 * l, 223, 16, 16);
                p_282430_.drawWordWrap(this.font, formattedtext, j1, j + 16 + 19 * l, l1, i2);
                i2 = 8453920;
            }
            p_282430_.drawString(this.font, s, j1 + 86 - this.font.width(s), j + 16 + 19 * l + 7, i2);
        }
    }

    private void renderBook(GuiGraphics p_289697_, int p_289667_, int p_289669_, float p_289670_) {
        float f = Mth.lerp((float)p_289670_, (float)this.oOpen, (float)this.open);
        float f1 = Mth.lerp((float)p_289670_, (float)this.oFlip, (float)this.flip);
        Lighting.setupForEntityInInventory();
        p_289697_.pose().pushPose();
        p_289697_.pose().translate((float)p_289667_ + 33.0f, (float)p_289669_ + 31.0f, 100.0f);
        p_289697_.pose().scale(-40.0f, 40.0f, 40.0f);
        p_289697_.pose().mulPose(Axis.XP.rotationDegrees(25.0f));
        p_289697_.pose().translate((1.0f - f) * 0.2f, (1.0f - f) * 0.1f, (1.0f - f) * 0.25f);
        float f3 = -(1.0f - f) * 90.0f - 90.0f;
        p_289697_.pose().mulPose(Axis.YP.rotationDegrees(f3));
        p_289697_.pose().mulPose(Axis.XP.rotationDegrees(180.0f));
        float f4 = Mth.clamp((float)(Mth.frac((float)(f1 + 0.25f)) * 1.6f - 0.3f), (float)0.0f, (float)1.0f);
        float f5 = Mth.clamp((float)(Mth.frac((float)(f1 + 0.75f)) * 1.6f - 0.3f), (float)0.0f, (float)1.0f);
        this.bookModel.setupAnim(0.0f, f4, f5, f);
        VertexConsumer vertexconsumer = p_289697_.bufferSource().getBuffer(this.bookModel.renderType(ENCHANTING_BOOK_LOCATION));
        this.bookModel.renderToBuffer(p_289697_.pose(), vertexconsumer, 0xF000F0, OverlayTexture.NO_OVERLAY);
        p_289697_.flush();
        p_289697_.pose().popPose();
        Lighting.setupFor3DItems();
    }

    public void render(GuiGraphics matrixStack, int mouseX, int mouseY, float partialTicks) {
        partialTicks = this.minecraft.getFrameTimeNs();
        this.renderBackground(matrixStack, mouseX, mouseY, partialTicks);
        super.render(matrixStack, mouseX, mouseY, partialTicks);
        this.renderTooltip(matrixStack, mouseX, mouseY);
        boolean flag = this.minecraft.player.getAbilities().instabuild;
        int i = ((AltarOfCorruptionMenu)this.menu).getGoldCount();
        for (int j = 0; j < 3; ++j) {
            int k = ((AltarOfCorruptionMenu)this.menu).costs[j];
            IdMap idmap = this.minecraft.level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).asHolderIdMap();
            Holder enchantment = (Holder)idmap.byId(((AltarOfCorruptionMenu)this.menu).enchantClue[j]);
            int l = ((AltarOfCorruptionMenu)this.menu).levelClue[j];
            int i1 = j + 1;
            if (!this.isHovering(60, 14 + 19 * j, 108, 17, mouseX, mouseY) || k <= 0) continue;
            ArrayList list = Lists.newArrayList();
            list.add(Component.translatable((String)"container.enchant.clue", (Object[])new Object[]{enchantment == null ? "" : Enchantment.getFullname((Holder)enchantment, (int)l)}).withStyle(ChatFormatting.WHITE));
            if (enchantment == null) {
                list.add(Component.literal((String)""));
                list.add(Component.translatable((String)"neoforge.container.enchant.limitedEnchantability").withStyle(ChatFormatting.RED));
            } else if (!flag) {
                list.add(CommonComponents.EMPTY);
                if (this.minecraft.player.experienceLevel < k) {
                    list.add(Component.translatable((String)"container.enchant.level.requirement", (Object[])new Object[]{((AltarOfCorruptionMenu)this.menu).costs[j]}).withStyle(ChatFormatting.RED));
                } else {
                    MutableComponent mutablecomponent = i1 == 1 ? Component.translatable((String)"container.enchant.lapis.one") : Component.translatable((String)"container.enchant.lapis.many", (Object[])new Object[]{i1});
                    list.add(mutablecomponent.withStyle(i >= i1 ? ChatFormatting.GRAY : ChatFormatting.RED));
                    MutableComponent mutablecomponent1 = i1 == 1 ? Component.translatable((String)"container.enchant.level.one") : Component.translatable((String)"container.enchant.level.many", (Object[])new Object[]{i1});
                    list.add(mutablecomponent1.withStyle(ChatFormatting.GRAY));
                }
            }
            matrixStack.renderComponentTooltip(this.font, (List)list, mouseX, mouseY);
            break;
        }
    }

    public void tickBook() {
        ItemStack itemstack = ((AltarOfCorruptionMenu)this.menu).getSlot(0).getItem();
        if (!ItemStack.matches((ItemStack)itemstack, (ItemStack)this.last)) {
            this.last = itemstack;
            do {
                this.flipT += (float)(this.random.nextInt(4) - this.random.nextInt(4));
            } while (this.flip <= this.flipT + 1.0f && this.flip >= this.flipT - 1.0f);
        }
        ++this.time;
        this.oFlip = this.flip;
        this.oOpen = this.open;
        boolean flag = false;
        for (int i = 0; i < 3; ++i) {
            if (((AltarOfCorruptionMenu)this.menu).costs[i] == 0) continue;
            flag = true;
        }
        this.open = flag ? (this.open += 0.2f) : (this.open -= 0.2f);
        this.open = Mth.clamp((float)this.open, (float)0.0f, (float)1.0f);
        float f1 = (this.flipT - this.flip) * 0.4f;
        f1 = Mth.clamp((float)f1, (float)-0.2f, (float)0.2f);
        this.flipA += (f1 - this.flipA) * 0.9f;
        this.flip += this.flipA;
    }
}

