/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.renders.tiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import divinerpg.block_entities.NightmareBedBlockEntity;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderNightmareBed
implements BlockEntityRenderer<NightmareBedBlockEntity> {
    private final ModelPart headRoot;
    private final ModelPart footRoot;
    public static final ModelLayerLocation HEAD = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"head"), "main");
    public static final ModelLayerLocation FOOT = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"foot"), "main");

    public RenderNightmareBed(BlockEntityRendererProvider.Context context) {
        this.headRoot = context.bakeLayer(HEAD);
        this.footRoot = context.bakeLayer(FOOT);
    }

    public static LayerDefinition createHeadLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("main", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 6.0f), PartPose.ZERO);
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(50, 6).addBox(0.0f, 6.0f, 0.0f, 3.0f, 3.0f, 3.0f), PartPose.rotation((float)1.5707964f, (float)0.0f, (float)1.5707964f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(50, 18).addBox(-16.0f, 6.0f, 0.0f, 3.0f, 3.0f, 3.0f), PartPose.rotation((float)1.5707964f, (float)0.0f, (float)((float)Math.PI)));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static LayerDefinition createFootLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("main", CubeListBuilder.create().texOffs(0, 22).addBox(0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 6.0f), PartPose.ZERO);
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(50, 0).addBox(0.0f, 6.0f, -16.0f, 3.0f, 3.0f, 3.0f), PartPose.rotation((float)1.5707964f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(50, 12).addBox(-16.0f, 6.0f, -16.0f, 3.0f, 3.0f, 3.0f), PartPose.rotation((float)1.5707964f, (float)0.0f, (float)4.712389f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void render(NightmareBedBlockEntity tile, float p_112206_, PoseStack poseStack, MultiBufferSource buffer, int light, int p_112210_) {
        Level level = tile.getLevel();
        if (level != null) {
            BlockState blockstate = tile.getBlockState();
            DoubleBlockCombiner.NeighborCombineResult neighborcombineresult = DoubleBlockCombiner.combineWithNeigbour((BlockEntityType)BlockEntityType.BED, BedBlock::getBlockType, BedBlock::getConnectedDirection, (DirectionProperty)ChestBlock.FACING, (BlockState)blockstate, (LevelAccessor)level, (BlockPos)tile.getBlockPos(), (p_112202_, p_112203_) -> false);
            int i = ((Int2IntFunction)neighborcombineresult.apply((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).get(light);
            this.renderPiece(poseStack, buffer, blockstate.getValue((Property)BedBlock.PART) == BedPart.HEAD ? this.headRoot : this.footRoot, (Direction)blockstate.getValue((Property)BedBlock.FACING), null, i, p_112210_, false);
        } else {
            this.renderPiece(poseStack, buffer, this.headRoot, Direction.SOUTH, null, light, p_112210_, false);
            this.renderPiece(poseStack, buffer, this.footRoot, Direction.SOUTH, null, light, p_112210_, true);
        }
    }

    private void renderPiece(PoseStack stack, MultiBufferSource bufferSource, ModelPart part, Direction direction, Material material, int p_173547_, int p_173548_, boolean p_173549_) {
        stack.pushPose();
        stack.translate(0.0f, 0.5625f, p_173549_ ? -1.0f : 0.0f);
        stack.mulPose(Axis.XP.rotationDegrees(90.0f));
        stack.translate(0.5f, 0.5f, 0.5f);
        stack.mulPose(Axis.ZP.rotationDegrees(180.0f + direction.toYRot()));
        stack.translate(-0.5f, -0.5f, -0.5f);
        VertexConsumer vertexconsumer = bufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"textures/block/nightmare_bed.png")));
        part.render(stack, vertexconsumer, p_173547_, p_173548_);
        stack.popPose();
    }
}

