/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.renders.tiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import divinerpg.block_entities.furnace.ArcaniumExtractorBlockEntity;
import divinerpg.blocks.arcana.BlockArcaniumExtractor;
import divinerpg.client.models.block.ModelArcaniumExtractor;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.Property;

public class RenderArcaniumExtractor
implements BlockEntityRenderer<ArcaniumExtractorBlockEntity> {
    private ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"textures/model/arcanium_extractor.png");
    private final ModelArcaniumExtractor<?> model;

    public RenderArcaniumExtractor(BlockEntityRendererProvider.Context context) {
        this.model = new ModelArcaniumExtractor(context.bakeLayer(ModelArcaniumExtractor.LAYER_LOCATION));
    }

    public void render(ArcaniumExtractorBlockEntity te, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        poseStack.pushPose();
        poseStack.translate(0.5, 0.0, 0.5);
        poseStack.mulPose(Axis.YP.rotationDegrees(((Direction)te.getBlockState().getValue((Property)BlockArcaniumExtractor.FACING)).toYRot()));
        VertexConsumer builder = buffer.getBuffer(RenderType.entityCutout((ResourceLocation)this.TEXTURE));
        this.model.renderToBuffer(poseStack, builder, combinedLight, combinedOverlay);
        poseStack.popPose();
    }
}

