/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.renders.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import divinerpg.entities.base.EntityDivineTameable;
import divinerpg.entities.vanilla.nether.EntityHellPig;
import divinerpg.entities.vanilla.overworld.EntityEhu;
import divinerpg.entities.vanilla.overworld.EntitySnapper;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PetCollarLayer
extends RenderLayer<EntityDivineTameable, EntityModel<EntityDivineTameable>> {
    private static final ResourceLocation EHU_COLLAR = ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"textures/entity/ehu_collar.png");
    private static final ResourceLocation HELL_PIG_COLLAR = ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"textures/entity/hell_pig/hell_pig_collar.png");
    private static final ResourceLocation SNAPPER_COLLAR = ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"textures/entity/snapper_collar.png");

    public PetCollarLayer(RenderLayerParent<EntityDivineTameable, EntityModel<EntityDivineTameable>> p_117707_) {
        super(p_117707_);
    }

    private ResourceLocation texture(Entity entity) {
        if (entity instanceof EntityEhu) {
            return EHU_COLLAR;
        }
        if (entity instanceof EntityHellPig) {
            return HELL_PIG_COLLAR;
        }
        if (entity instanceof EntitySnapper) {
            return SNAPPER_COLLAR;
        }
        return null;
    }

    public void render(PoseStack stack, MultiBufferSource source, int p_117722_, EntityDivineTameable entity, float p_117724_, float p_117725_, float p_117726_, float p_117727_, float p_117728_, float p_117729_) {
        if (entity.isTame() && !entity.isInvisible()) {
            int i = entity.getCollarColor().getTextureDiffuseColor();
            PetCollarLayer.renderColoredCutoutModel((EntityModel)this.getParentModel(), (ResourceLocation)this.texture((Entity)entity), (PoseStack)stack, (MultiBufferSource)source, (int)p_117722_, (LivingEntity)entity, (int)i);
        }
    }
}

