/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.renders.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.items.base.DivineShield;
import net.minecraft.client.model.ShieldModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class DivineShieldRenderer
extends BlockEntityWithoutLevelRenderer {
    private final ShieldModel model;

    public DivineShieldRenderer(BlockEntityRenderDispatcher dispatcher, EntityModelSet set) {
        super(dispatcher, set);
        this.model = new ShieldModel(set.bakeLayer(ModelLayers.SHIELD));
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext context, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        super.renderByItem(stack, context, matrixStack, buffer, combinedLight, combinedOverlay);
        Item item = stack.getItem();
        if (item instanceof DivineShield) {
            matrixStack.pushPose();
            matrixStack.scale(1.0f, -1.0f, -1.0f);
            VertexConsumer builder = buffer.getBuffer(RenderType.entityCutout((ResourceLocation)((DivineShield)item).resource));
            this.model.renderToBuffer(matrixStack, builder, combinedLight, combinedOverlay);
            matrixStack.popPose();
        }
    }
}

