/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.particle.options;

import com.mojang.serialization.MapCodec;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.FastColor;

public class ParticleColouredOption
implements ParticleOptions {
    private final ParticleType<ParticleColouredOption> type;
    private final int color;

    public static MapCodec<ParticleColouredOption> codec(ParticleType<ParticleColouredOption> particleType) {
        return ExtraCodecs.ARGB_COLOR_CODEC.xmap(color -> new ParticleColouredOption(particleType, (int)color), option -> option.color).fieldOf("color");
    }

    public static StreamCodec<? super ByteBuf, ParticleColouredOption> streamCodec(ParticleType<ParticleColouredOption> particleType) {
        return ByteBufCodecs.INT.map(color -> new ParticleColouredOption(particleType, (int)color), option -> option.color);
    }

    public ParticleColouredOption(ParticleType<ParticleColouredOption> type, int color) {
        this.type = type;
        this.color = color;
    }

    public ParticleType<ParticleColouredOption> getType() {
        return this.type;
    }

    public float getRed() {
        return (float)FastColor.ARGB32.red((int)this.color) / 255.0f;
    }

    public float getGreen() {
        return (float)FastColor.ARGB32.green((int)this.color) / 255.0f;
    }

    public float getBlue() {
        return (float)FastColor.ARGB32.blue((int)this.color) / 255.0f;
    }

    public float getAlpha() {
        return (float)FastColor.ARGB32.alpha((int)this.color) / 255.0f;
    }

    public static ParticleColouredOption create(ParticleType<ParticleColouredOption> type, int color) {
        return new ParticleColouredOption(type, color);
    }

    public static ParticleColouredOption create(ParticleType<ParticleColouredOption> type, float red, float green, float blue) {
        return ParticleColouredOption.create(type, FastColor.ARGB32.colorFromFloat((float)1.0f, (float)red, (float)green, (float)blue));
    }
}

