/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ParticleFrost
extends TextureSheetParticle {
    SpriteSet animatedSprite;
    final float rotSpeed;
    float oSize;

    public ParticleFrost(ClientLevel worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeed, double ySpeed, double zSpeed, SpriteSet sprite) {
        this(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeed, ySpeed, zSpeed, 1.0f, sprite);
    }

    public ParticleFrost(ClientLevel worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeed, double ySpeed, double zSpeed, float scale, SpriteSet sprite) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeed, ySpeed, zSpeed);
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
        this.quadSize *= 0.75f;
        this.quadSize *= 0.9f;
        this.oSize = this.quadSize;
        this.lifetime = (int)(32.0 / (Math.random() * 0.8 + 0.2));
        this.lifetime = (int)((float)this.lifetime * 0.5f);
        float f = (float)Math.random() * 0.4f + 0.6f;
        this.rCol = ((float)(Math.random() * (double)0.2f) + 0.8f) * f;
        this.rotSpeed = ((float)Math.random() - 0.9f) * 0.1f;
        this.roll = (float)Math.random() * ((float)Math.PI * 2);
        this.animatedSprite = sprite;
    }

    protected int getLightColor(float partialTick) {
        int var2 = super.getLightColor(partialTick);
        float var3 = (float)this.age / (float)this.lifetime;
        var3 *= var3;
        var3 *= var3;
        int var4 = var2 & 0xFF;
        int var5 = var2 >> 16 & 0xFF;
        if ((var5 += (int)(var3 * 15.0f * 16.0f)) > 240) {
            var5 = 240;
        }
        return var4 | var5 << 16;
    }

    public void render(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        float f = ((float)this.age + partialTicks) / (float)this.lifetime * 2.0f;
        f = Mth.clamp((float)f, (float)0.0f, (float)1.0f);
        this.quadSize = this.oSize * f;
        super.render(buffer, renderInfo, partialTicks);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.alpha = ((float)this.lifetime - (float)this.age) / 50.0f;
        if (this.age++ >= this.lifetime) {
            this.alpha = 0.0f;
            this.remove();
        }
        this.oRoll = this.roll;
        this.roll += (float)Math.PI * this.rotSpeed * 1.0f;
        if (this.onGround) {
            this.roll = 0.0f;
            this.oRoll = 0.0f;
        }
        this.move(this.xd, this.yd, this.zd);
        this.yd -= 3.00000026077032E-4;
        this.yd = Math.max(this.yd, -0.04000000059604645);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel world, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeed, double ySpeed, double zSpeed) {
            ParticleFrost particle = new ParticleFrost(world, xCoordIn, yCoordIn, zCoordIn, xSpeed, ySpeed, zSpeed, this.sprites);
            particle.pickSprite(this.sprites);
            return particle;
        }
    }
}

