/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.particle;

import divinerpg.client.particle.options.ParticleColouredOption;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.particle.SpriteSet;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ParticleColored
extends SimpleAnimatedParticle {
    private double portalPosX;
    private double portalPosY;
    private double portalPosZ;

    protected ParticleColored(ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet pSprites, int red, int green, int blue) {
        super(world, x, y, z, pSprites, -0.05f);
        this.xd = xSpeed;
        this.yd = ySpeed;
        this.zd = zSpeed;
        this.quadSize *= 0.75f;
        this.lifetime = 60 + this.random.nextInt(12);
        this.portalPosX = this.x = x;
        this.portalPosY = this.y = y;
        this.portalPosZ = this.z = z;
        this.setSpriteFromAge(pSprites);
        this.setColor((float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f);
        this.friction = 0.6f;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public int getLightColor(float partialTick) {
        int var2 = super.getLightColor(partialTick);
        float var3 = (float)this.age / (float)this.lifetime;
        var3 *= var3;
        var3 *= var3;
        int var4 = var2 & 0xFF;
        int var5 = var2 >> 16 & 0xFF;
        if ((var5 += (int)(var3 * 15.0f * 16.0f)) > 240) {
            var5 = 240;
        }
        return var4 | var5 << 16;
    }

    public void tick() {
        float var1;
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        float var2 = var1 = (float)this.age / (float)this.lifetime;
        var1 = -var1 + var1 * var1 * 2.0f;
        var1 = 1.0f - var1;
        this.x = this.portalPosX + this.xd * (double)var1;
        this.y = this.portalPosY + this.yd * (double)var1 + (double)(1.0f - var2);
        this.z = this.portalPosZ + this.zd * (double)var1;
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
    }

    public static class Provider
    implements ParticleProvider<ParticleColouredOption> {
        private final SpriteSet sprites;

        public Provider(SpriteSet pSprites) {
            this.sprites = pSprites;
        }

        @Nullable
        public Particle createParticle(ParticleColouredOption data, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new ParticleColored(level, x, y, z, xSpeed, ySpeed, zSpeed, this.sprites, (int)data.getRed(), (int)data.getGreen(), (int)data.getBlue());
        }
    }
}

